/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.model;

import de.mn77.base.error.Err;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.A_ObjectToString;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Output;

public class ArgCallBuffer
extends A_ObjectToString {
    private Call call;
    private I_Object obj = null;
    private boolean init = false;
    private Class<? extends I_Object>[] typecheck = null;
    private final int argIdx;

    public ArgCallBuffer(int argIdx, Call c) {
        Err.ifNull(c);
        this.call = c;
        this.argIdx = argIdx;
    }

    public I_Object init(CallRuntime cr, I_Object streamIt, Class<? extends I_Object> type) {
        if (this.init) {
            Err.todo("Already init!", this.obj, type);
        }
        this.obj = cr.instanceArgType(this.argIdx, cr.execInit(this.call, streamIt), type);
        this.typecheck = new Class[]{type};
        this.init = true;
        return this.obj;
    }

    @SafeVarargs
    public final I_Object initExt(CallRuntime cr, I_Object streamIt, Class<? extends I_Object> ... types) {
        if (this.init) {
            Err.todo("Already init!", this.obj, this.call, streamIt, types);
        }
        this.obj = cr.instanceArgTypeExt(this.argIdx, cr.execInit(this.call, streamIt), types);
        this.typecheck = types;
        this.init = true;
        return this.obj;
    }

    public I_Object get() {
        if (!this.init) {
            Err.invalid("ParCallBuffer not initialized!", this.call);
        }
        return this.obj;
    }

    @SafeVarargs
    public final I_Object getInitLoop(CallRuntime cr, I_Object streamIt, Class<? extends I_Object> ... types) {
        if (!this.init) {
            this.typecheck = types;
            this.init = true;
        }
        return cr.argTypeExt(cr.execInit(this.call, streamIt), this.typecheck);
    }

    @SafeVarargs
    public final I_Object getInitEach(CallRuntime cr, I_Object streamIt, I_Object each, Class<? extends I_Object> ... types) {
        if (!this.init) {
            this.typecheck = types;
            this.init = true;
        }
        return cr.argTypeExt(cr.execEachInit(this.call, streamIt, each), this.typecheck);
    }

    public void replace(Call c) {
        this.call = c;
    }

    @Override
    public String toStringDescribe(CallRuntime cr) {
        return this.obj != null ? this.obj.toStringDescribe(cr) : this.call.toStringDescribe(cr);
    }

    @Override
    public String toStringIdent(CallRuntime cr) {
        return this.obj != null ? this.obj.toStringIdent(cr) : this.call.toStringIdent(cr);
    }

    @Override
    public String toString(boolean nested) {
        if (nested) {
            return this.obj != null ? this.obj.toString(false) : this.call.toString(false);
        }
        return this.obj != null ? Lib_Output.toString(this.obj, true) : Lib_Output.toString(this.call, false);
    }

    public Call getInternalCall() {
        return this.call;
    }
}

