/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.bricklink;

import de.mn77.base.data.convert.ConvSequence;
import de.mn77.base.data.struct.table.MTable;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import de.mn77.base.sys.Sys;
import de.mn77.lib.graphic.MImageX;
import de.mn77.lib.json.Json;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jaymo_lang.error.ErrorBaseDebug;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.error.ExtError;
import org.jaymo_lang.lib.bricklink.BL_Auth;
import org.jaymo_lang.lib.bricklink.BL_METHOD;
import org.jaymo_lang.lib.bricklink.BricklinkIncExc;
import org.jaymo_lang.lib.bricklink.ItemCreateData;
import org.jaymo_lang.lib.bricklink.Lib_Bricklink;
import org.jaymo_lang.lib.graphic.JMo_Image;
import org.jaymo_lang.lib.json.Lib_Json;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_Atomic;
import org.jaymo_lang.object.atom.A_DecNumber;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.Nil;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.datetime.JMo_Date;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.object.struct.JMo_Map;
import org.jaymo_lang.object.struct.JMo_Table;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;
import org.jaymo_lang.util.Lib_Java;

public class JMo_BrickLinkAPI
extends A_ObjectSimple {
    private static final boolean DEBUG = false;
    private final Map<String, String> httpPropertys = new HashMap<String, String>();
    private String proxyURL = null;
    private String proxyKey = null;
    private int blCallsTotal = 0;
    private int blCallsSuccess = 0;
    private Integer limit = null;
    private final BL_Auth auth = new BL_Auth();

    @Override
    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "setAuth": {
                this.setAuth(cr);
                return this;
            }
            case "setConsumer": {
                this.setConsumer(cr);
                return this;
            }
            case "setToken": {
                this.setToken(cr);
                return this;
            }
            case "addHttpProperty": {
                this.addHttpProperty(cr);
                return this;
            }
            case "setProxy": {
                this.setProxy(cr);
                return this;
            }
            case "setLimit": {
                this.setLimit(cr);
                return this;
            }
            case "getCallsTotal": 
            case "getCalls": {
                cr.args();
                return new Int(this.blCallsTotal);
            }
            case "getCallsSuccess": {
                cr.args();
                return new Int(this.blCallsSuccess);
            }
            case "getOrdersIn": {
                return this.getOrders(cr, true);
            }
            case "getOrdersOut": {
                return this.getOrders(cr, false);
            }
            case "getOrder": {
                return this.getOrder(cr);
            }
            case "getOrderItems": {
                return this.getOrderItems(cr);
            }
            case "getOrderMessages": {
                return this.getOrderMessages(cr);
            }
            case "getOrderFeedback": {
                return this.getOrderFeedback(cr);
            }
            case "updateOrder": {
                return this.updateOrder(cr);
            }
            case "updateOrderStatus": {
                return this.updateOrderStatus(cr);
            }
            case "updateOrderPayment": {
                return this.updateOrderPaymentStatus(cr);
            }
            case "orderSendDriveThru": {
                return this.orderSendDriveThru(cr);
            }
            case "getInventories": {
                return this.getInventories(cr);
            }
            case "getInventory": {
                return this.getInventory(cr);
            }
            case "createInventory": {
                return this.createInventory(cr);
            }
            case "updateInventory": {
                return this.updateInventory(cr);
            }
            case "deleteInventory": {
                return this.deleteInventory(cr);
            }
            case "getItem": {
                return this.getItem(cr);
            }
            case "getImage": 
            case "getItemImage": {
                return this.getImage(cr);
            }
            case "getSuperSets": 
            case "getSupersets": {
                return this.getSuperSets(cr);
            }
            case "getSubSets": 
            case "getSubsets": {
                return this.getSubSets(cr);
            }
            case "getPriceGuide": {
                return this.getPriceGuide(cr);
            }
            case "getKnownColors": {
                return this.getKnownColors(cr);
            }
            case "getKnownColorValues": {
                return this.getKnownColorValues(cr);
            }
            case "getThumbnailURL": {
                return this.getThumbnail(cr, false);
            }
            case "getThumbnail": {
                return this.getThumbnail(cr, true);
            }
            case "getFeedbacksIn": {
                return this.getFeedbacks(cr, true);
            }
            case "getFeedbacksOut": {
                return this.getFeedbacks(cr, false);
            }
            case "getFeedback": {
                return this.getFeedback(cr);
            }
            case "postFeedback": {
                return this.postFeedback(cr);
            }
            case "replyFeedback": {
                return this.replyFeedback(cr);
            }
            case "getColors": 
            case "getColorList": {
                return this.getColors(cr);
            }
            case "getColor": {
                return this.getColor(cr);
            }
            case "getCategories": {
                return this.getCategories(cr);
            }
            case "getCategory": {
                return this.getCategory(cr);
            }
            case "getCouponsIn": {
                return this.getCoupons(cr, true);
            }
            case "getCouponsOut": {
                return this.getCoupons(cr, false);
            }
            case "getCoupon": {
                return this.getCoupon(cr);
            }
            case "createCoupon": {
                return this.createCoupon(cr);
            }
            case "deleteCoupon": {
                return this.deleteCoupon(cr);
            }
            case "getShippingMethods": 
            case "getShippingMethodList": {
                return this.getShippingMethodList(cr);
            }
            case "getShippingMethod": {
                return this.getShippingMethod(cr);
            }
            case "getMemberRating": {
                return this.getMemberRating(cr);
            }
        }
        return null;
    }

    private void setAuth(CallRuntime cr) {
        I_Object[] oa = cr.args(this, Str.class, Str.class, Str.class, Str.class);
        String consumerKey = Lib_Convert.getStringValue(cr, oa[0]);
        String consumerSecret = Lib_Convert.getStringValue(cr, oa[1]);
        String tokenValue = Lib_Convert.getStringValue(cr, oa[2]);
        String tokenSecret = Lib_Convert.getStringValue(cr, oa[3]);
        this.auth.setAuth(consumerKey, consumerSecret, tokenValue, tokenSecret);
    }

    private void setConsumer(CallRuntime cr) {
        I_Object[] oa = cr.args(this, Str.class, Str.class);
        String consumerKey = Lib_Convert.getStringValue(cr, oa[0]);
        String consumerSecret = Lib_Convert.getStringValue(cr, oa[1]);
        this.auth.setConsumer(consumerKey, consumerSecret);
    }

    private void setToken(CallRuntime cr) {
        I_Object[] oa = cr.args(this, Str.class, Str.class);
        String tokenValue = Lib_Convert.getStringValue(cr, oa[0]);
        String tokenSecret = Lib_Convert.getStringValue(cr, oa[1]);
        this.auth.setToken(tokenValue, tokenSecret);
    }

    private void addHttpProperty(CallRuntime cr) {
        I_Object[] oa = cr.args(this, Str.class, Str.class);
        String key = Lib_Convert.getStringValue(cr, oa[0]);
        String val = Lib_Convert.getStringValue(cr, oa[1]);
        this.httpPropertys.put(key, val);
    }

    private void setProxy(CallRuntime cr) {
        I_Object[] oa = cr.args(this, Str.class, Str.class);
        String url = Lib_Convert.getStringValue(cr, oa[0]);
        String key = Lib_Convert.getStringValue(cr, oa[1]);
        this.proxyURL = url;
        this.proxyKey = key;
    }

    private void setLimit(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        this.limit = Lib_Convert.getIntValue(cr, arg);
    }

    private I_Object getOrders(CallRuntime cr, boolean in) {
        I_Object[] arg = cr.argsFlex(this, 0, 2);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("direction", in ? "in" : "out");
        boolean filed = arg.length == 0 ? false : Lib_Convert.getBoolValue(cr, cr.argType(arg[0], Bool.class));
        props.put("filed", filed ? "true" : "false");
        if (arg.length == 2) {
            BricklinkIncExc statusIE = new BricklinkIncExc(cr, arg[1]);
            statusIE.check(value -> Lib_Bricklink.checkOrderState(cr, value));
            if (statusIE.hasItems()) {
                props.put("status", ConvSequence.toText(",", statusIE.generate()));
            }
        }
        Object json = this.bricklinkGet(cr, BL_METHOD.GET, "/orders", this.auth, props, null);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object getOrder(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int order_id = Lib_Convert.getIntValue(cr, arg);
        Object json = this.bricklinkGet(cr, BL_METHOD.GET, "/orders/" + order_id, this.auth, null, null);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object getOrderItems(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int order_id = Lib_Convert.getIntValue(cr, arg);
        String url = "/orders/" + order_id + "/items";
        ArrayList json = (ArrayList)this.bricklinkGet(cr, BL_METHOD.GET, url, this.auth, null, null);
        if (json.size() == 0) {
            return new JMo_List();
        }
        Object json2 = json.get(0);
        return Lib_Json.jsonToJMo(json2);
    }

    private I_Object getOrderMessages(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int order_id = Lib_Convert.getIntValue(cr, arg);
        Object json = this.bricklinkGet(cr, BL_METHOD.GET, "/orders/" + order_id + "/messages", this.auth, null, null);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object getOrderFeedback(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int order_id = Lib_Convert.getIntValue(cr, arg);
        Object json = this.bricklinkGet(cr, BL_METHOD.GET, "/orders/" + order_id + "/feedback", this.auth, null, null);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object updateOrder(CallRuntime cr) {
        I_Object[] args = cr.args(this, A_IntNumber.class, JMo_Map.class);
        int order_id = Lib_Convert.getIntValue(cr, args[0]);
        JMo_Map requestBody = (JMo_Map)args[1];
        HashMap<String, String> requestProps = new HashMap<String, String>();
        for (Map.Entry<I_Object, I_Object> e : requestBody.copyToHashMap().entrySet()) {
            String key;
            switch (key = Lib_Convert.getStringValue(cr, e.getKey()).toLowerCase()) {
                case "shipping.date_shipped": {
                    requestProps.put(key, cr.argType(e.getValue(), JMo_Date.class).toString());
                    break;
                }
                case "cost.insurance": 
                case "cost.shipping": 
                case "cost.etc1": 
                case "cost.etc2": 
                case "cost.credit": {
                    requestProps.put(key, cr.argType(e.getValue(), A_DecNumber.class).toString());
                    break;
                }
                case "shipping.method_id": {
                    requestProps.put(key, cr.argType(e.getValue(), A_IntNumber.class).toString());
                    break;
                }
                case "shipping.tracking_link": 
                case "shipping.tracking_no": 
                case "remarks": {
                    requestProps.put(key, cr.argType(e.getValue(), Str.class).toString());
                    break;
                }
                case "is_filed": {
                    requestProps.put(key, ((Bool)cr.argType(e.getValue(), Bool.class)).toString());
                    break;
                }
                default: {
                    throw new ExecError(cr, "Invalid key", "Key is not known: " + key);
                }
            }
        }
        Map<String, Object> requestProps2 = Lib_Bricklink.convertDotToTree(requestProps);
        Object json = this.bricklinkGet(cr, BL_METHOD.PUT, "/orders/" + order_id, this.auth, null, requestProps2);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object updateOrderStatus(CallRuntime cr) {
        I_Object[] args = cr.args(this, A_IntNumber.class, Str.class);
        int order_id = Lib_Convert.getIntValue(cr, args[0]);
        String status = Lib_Convert.getStringValue(cr, args[1]);
        status = Lib_Bricklink.checkOrderState(cr, status);
        HashMap<String, Object> requestProps = new HashMap<String, Object>();
        requestProps.put("field", "status");
        requestProps.put("value", status);
        Object json = this.bricklinkGet(cr, BL_METHOD.PUT, "/orders/" + order_id + "/status", this.auth, null, requestProps);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object updateOrderPaymentStatus(CallRuntime cr) {
        I_Object[] args = cr.args(this, A_IntNumber.class, Str.class);
        int order_id = Lib_Convert.getIntValue(cr, args[0]);
        String status = Lib_Convert.getStringValue(cr, args[1]);
        status = Lib_Bricklink.checkPaymentState(cr, status);
        HashMap<String, Object> requestProps = new HashMap<String, Object>();
        requestProps.put("field", "payment_status");
        requestProps.put("value", status);
        Object json = this.bricklinkGet(cr, BL_METHOD.PUT, "/orders/" + order_id + "/status", this.auth, null, requestProps);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object orderSendDriveThru(CallRuntime cr) {
        I_Object[] args = cr.args(this, A_IntNumber.class, Bool.class);
        int order_id = Lib_Convert.getIntValue(cr, args[0]);
        boolean mail_me = Lib_Convert.getBoolValue(cr, args[1]);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("mail_me", mail_me ? "true" : "false");
        Object json = this.bricklinkGet(cr, BL_METHOD.POST, "/orders/" + order_id + "/drive_thru", this.auth, props, null);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object getInventories(CallRuntime cr) {
        HashMap<String, String> params;
        block17: {
            I_Object[] args = cr.argsFlex(this, 0, 1);
            params = null;
            if (args.length != 1) break block17;
            params = new HashMap<String, String>();
            JMo_Map arg = (JMo_Map)cr.argType(args[0], JMo_Map.class);
            for (Map.Entry<I_Object, I_Object> e : arg.copyToHashMap().entrySet()) {
                String key;
                switch (key = cr.argType(e.getKey(), Str.class).toString().toLowerCase()) {
                    case "item_type": {
                        BricklinkIncExc itIE1 = new BricklinkIncExc(cr, e.getValue());
                        itIE1.check(value -> Lib_Bricklink.checkItemType(cr, value));
                        params.put("item_type", itIE1.generate());
                        break;
                    }
                    case "status": {
                        BricklinkIncExc itIE2 = new BricklinkIncExc(cr, e.getValue());
                        itIE2.check(value -> Lib_Bricklink.checkInventoryStatus(cr, value));
                        params.put("status", itIE2.generate());
                        break;
                    }
                    case "category_id": {
                        BricklinkIncExc itIE3 = new BricklinkIncExc(cr, e.getValue());
                        itIE3.check(value -> "" + Lib_Bricklink.checkInteger(cr, value));
                        params.put("category_id", itIE3.generate());
                        break;
                    }
                    case "color_id": {
                        BricklinkIncExc itIE4 = new BricklinkIncExc(cr, e.getValue());
                        itIE4.check(value -> "" + Lib_Bricklink.checkInteger(cr, value));
                        params.put("color_id", itIE4.generate());
                    }
                }
            }
        }
        Object json = this.bricklinkGet(cr, BL_METHOD.GET, "/inventories", this.auth, params, null);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object getInventory(CallRuntime cr) {
        I_Object args = cr.args(this, A_IntNumber.class)[0];
        String id = Lib_Convert.getStringValue(cr, args);
        Object json = this.bricklinkGet(cr, BL_METHOD.GET, "/inventories/" + id, this.auth, null, null);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object deleteInventory(CallRuntime cr) {
        I_Object args = cr.args(this, A_IntNumber.class)[0];
        String id = Lib_Convert.getStringValue(cr, args);
        Object json = this.bricklinkGet(cr, BL_METHOD.DELETE, "/inventories/" + id, this.auth, null, null);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object createInventory(CallRuntime cr) {
        JMo_Map requestData = (JMo_Map)cr.args(this, JMo_Map.class)[0];
        ItemCreateData itemData = new ItemCreateData();
        itemData.fill(cr, requestData.copyToHashMap());
        itemData.check(cr);
        Map<String, String> requestProps = itemData.getMap();
        Map<String, Object> requestProps2 = Lib_Bricklink.convertDotToTree(requestProps);
        Object json = this.bricklinkGet(cr, BL_METHOD.POST, "/inventories", this.auth, null, requestProps2);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object updateInventory(CallRuntime cr) {
        I_Object[] oa = cr.args(this, A_Atomic.class, JMo_Map.class);
        String id = Lib_Convert.getStringValue(cr, oa[0]);
        JMo_Map requestBody = (JMo_Map)oa[1];
        HashMap<String, Object> request_props = new HashMap<String, Object>();
        for (Map.Entry<I_Object, I_Object> e : requestBody.copyToHashMap().entrySet()) {
            String key = Lib_Convert.getStringValue(cr, e.getKey());
            String value = Lib_Convert.getStringValue(cr, e.getValue());
            request_props.put(key, value);
        }
        String uri = "/inventories/" + id;
        Object json = this.bricklinkGet(cr, BL_METHOD.PUT, uri, this.auth, null, request_props);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object getItem(CallRuntime cr) {
        I_Object[] oa = cr.args(this, Str.class, A_Atomic.class);
        String type = Lib_Convert.getStringValue(cr, oa[0]);
        String no = Lib_Convert.getStringValue(cr, oa[1]);
        String type2 = Lib_Bricklink.checkItemType(cr, type);
        String urlGet = "/items/" + type2 + "/" + no;
        Object json = this.bricklinkGet(cr, BL_METHOD.GET, urlGet, this.auth, null, null);
        return Lib_Json.jsonToJMo(json);
    }

    private JMo_Image getImage(CallRuntime cr) {
        Integer color;
        String no;
        I_Object[] oa = cr.argsFlex(this, 2, 3);
        String type = Lib_Convert.getStringValue(cr, cr.argType(oa[0], Str.class));
        String urlString = Lib_Bricklink.getImageURL(type, no = Lib_Convert.getStringValue(cr, cr.argType(oa[1], A_Atomic.class)), color = oa.length == 2 || oa[2] == Nil.NIL ? null : Integer.valueOf(Lib_Convert.getIntValue(cr, cr.argType(oa[2], A_IntNumber.class))));
        if (urlString == null) {
            throw new ExtError(cr, "Image URL error", "Not implemented type of item. Type: " + type + ", No: " + no + ", Color: " + color);
        }
        try {
            URL url = new URL(urlString);
            BufferedImage awtImage = ImageIO.read(url);
            if (awtImage == null) {
                throw new ExtError(cr, "Image download error", "Can't download image from URL: " + url);
            }
            MImageX mImage = new MImageX(awtImage);
            return new JMo_Image(mImage);
        }
        catch (ErrorBaseDebug e) {
            throw e;
        }
        catch (Err_Runtime e) {
            throw e;
        }
        catch (Exception e) {
            Err.show(e);
            throw new ExtError(cr, "Image download error", e.getMessage());
        }
    }

    private I_Object getSuperSets(CallRuntime cr) {
        I_Object[] oa = cr.argsFlex(this, 2, 3);
        String type = Lib_Convert.getStringValue(cr, cr.argType(oa[0], Str.class));
        String no = Lib_Convert.getStringValue(cr, cr.argType(oa[1], A_Atomic.class));
        HashMap<String, String> uriProps = null;
        if (oa.length == 3) {
            String color = Lib_Convert.getStringValue(cr, cr.argType(oa[2], A_IntNumber.class));
            uriProps = new HashMap<String, String>();
            uriProps.put("color_id", color);
        }
        String type2 = Lib_Bricklink.checkItemType(cr, type);
        String urlGet = "/items/" + type2 + "/" + no + "/supersets";
        Object json = this.bricklinkGet(cr, BL_METHOD.GET, urlGet, this.auth, uriProps, null);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object getSubSets(CallRuntime cr) {
        String color;
        I_Object[] args = cr.argsFlex(this, 2, 7);
        String type = Lib_Convert.getStringValue(cr, cr.argType(args[0], Str.class));
        String no = Lib_Convert.getStringValue(cr, cr.argType(args[1], A_Atomic.class));
        HashMap<String, String> uriProps = new HashMap<String, String>();
        if (args.length >= 3) {
            color = Lib_Convert.getStringValue(cr, cr.argType(args[2], A_IntNumber.class));
            uriProps.put("color_id", color);
        }
        if (args.length >= 4) {
            color = Lib_Convert.getStringValue(cr, cr.argType(args[3], Bool.class));
            uriProps.put("box", color);
        }
        if (args.length >= 5) {
            color = Lib_Convert.getStringValue(cr, cr.argType(args[4], Bool.class));
            uriProps.put("instruction", color);
        }
        if (args.length >= 6) {
            color = Lib_Convert.getStringValue(cr, cr.argType(args[5], Bool.class));
            uriProps.put("break_minifigs", color);
        }
        if (args.length == 7) {
            color = Lib_Convert.getStringValue(cr, cr.argType(args[6], Bool.class));
            uriProps.put("break_subsets", color);
        }
        String type2 = Lib_Bricklink.checkItemType(cr, type);
        String urlGet = "/items/" + type2 + "/" + no + "/subsets";
        Object json = this.bricklinkGet(cr, BL_METHOD.GET, urlGet, this.auth, uriProps, null);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object getPriceGuide(CallRuntime cr) {
        I_Object[] oa = cr.args(this, Str.class, A_Atomic.class, A_IntNumber.class, Bool.class, Bool.class, JMo_Map.class);
        String type = Lib_Convert.getStringValue(cr, oa[0]);
        String no = Lib_Convert.getStringValue(cr, oa[1]);
        String color_id = Lib_Convert.getStringValue(cr, oa[2]);
        String new_or_used = Lib_Convert.getBoolValue(cr, oa[3]) ? "N" : "U";
        String sold_or_stock = Lib_Convert.getBoolValue(cr, oa[4]) ? "sold" : "stock";
        HashMap<I_Object, I_Object> props = ((JMo_Map)oa[5]).copyToHashMap();
        String urlGet = "/items/" + type + "/" + no + "/price";
        HashMap<String, String> propertys = new HashMap<String, String>();
        propertys.put("color_id", color_id);
        propertys.put("new_or_used", new_or_used);
        propertys.put("guide_type", sold_or_stock);
        for (Map.Entry entry : props.entrySet()) {
            propertys.put(Lib_Convert.getStringValue(cr, (I_Object)entry.getKey()), Lib_Convert.getStringValue(cr, (I_Object)entry.getValue()));
        }
        Object json = this.bricklinkGet(cr, BL_METHOD.GET, urlGet, this.auth, propertys, null);
        return Lib_Json.jsonToMap((HashMap)json, "max_price", "min_price", "qty_avg_price", "total_quantity", "avg_price", "unit_quantity");
    }

    private I_Object getKnownColorValues(CallRuntime cr) {
        I_Object[] oa = cr.args(this, Str.class, A_Atomic.class);
        String type = Lib_Convert.getStringValue(cr, oa[0]);
        String no = Lib_Convert.getStringValue(cr, oa[1]);
        String urlGet = "/items/" + type + "/" + no + "/colors";
        Object json = this.bricklinkGet(cr, BL_METHOD.GET, urlGet, this.auth, null, null);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object getKnownColors(CallRuntime cr) {
        I_Object[] oa = cr.args(this, Str.class, A_Atomic.class);
        String type = Lib_Convert.getStringValue(cr, oa[0]);
        String no = Lib_Convert.getStringValue(cr, oa[1]);
        String urlGet = "/items/" + type + "/" + no + "/colors";
        Object json = this.bricklinkGet(cr, BL_METHOD.GET, urlGet, this.auth, null, null);
        ArrayList<I_Object> al = new ArrayList<I_Object>();
        ArrayList arr = (ArrayList)json;
        Object[] objectArray = arr.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            al.add(Lib_Json.jsonToJMo(((HashMap)item).get("color_id")));
            ++n2;
        }
        return new JMo_List(al);
    }

    private I_Object getThumbnail(CallRuntime cr, boolean download) {
        I_Object[] oa = cr.args(this, Str.class, Str.class, A_IntNumber.class);
        String type = Lib_Convert.getStringValue(cr, oa[0]);
        String no = Lib_Convert.getStringValue(cr, oa[1]);
        int color_id = Lib_Convert.getIntValue(cr, oa[2]);
        String urlString = "https:" + this.iGetImageURL(cr, type, no, color_id);
        if (!download) {
            return new Str(urlString);
        }
        BufferedImage awtImage = null;
        try {
            URL url = new URL(urlString);
            awtImage = ImageIO.read(url);
            MImageX mImage = new MImageX(awtImage);
            return new JMo_Image(mImage);
        }
        catch (Exception e) {
            throw new ExtError(cr, "Image download error - " + e.getMessage(), "URL: " + urlString);
        }
    }

    private String iGetImageURL(CallRuntime cr, String type, String no, int color_id) {
        String urlGet = "/items/" + type + "/" + no + "/images/" + color_id;
        Object json = this.bricklinkGet(cr, BL_METHOD.GET, urlGet, this.auth, null, null);
        return Lib_Json.jsonToString((HashMap)json, "thumbnail_url");
    }

    private I_Object getFeedbacks(CallRuntime cr, boolean in) {
        cr.args();
        HashMap<String, String> urlProps = new HashMap<String, String>();
        urlProps.put("direction", in ? "in" : "out");
        Object json = this.bricklinkGet(cr, BL_METHOD.GET, "/feedback", this.auth, urlProps, null);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object getFeedback(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        String no = Lib_Convert.getStringValue(cr, arg);
        Object json = this.bricklinkGet(cr, BL_METHOD.GET, "/feedback/" + no, this.auth, null, null);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object postFeedback(CallRuntime cr) {
        I_Object[] args = cr.args(this, A_IntNumber.class, A_IntNumber.class, Str.class);
        String orderID = Lib_Convert.getStringValue(cr, args[0]);
        int rating = Lib_Convert.getIntValue(cr, args[1]);
        String comment = Lib_Convert.getStringValue(cr, args[2]);
        Lib_Error.ifNotBetween(cr, 0, 2, rating, "Rating");
        Lib_Error.ifEmpty(cr, comment, "Comment");
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("order_id", orderID);
        requestBody.put("rating", "" + rating);
        requestBody.put("comment", comment);
        Object json = this.bricklinkGet(cr, BL_METHOD.POST, "/feedback", this.auth, null, requestBody);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object replyFeedback(CallRuntime cr) {
        I_Object[] args = cr.args(this, A_IntNumber.class, Str.class);
        String no = Lib_Convert.getStringValue(cr, args[0]);
        String reply = Lib_Convert.getStringValue(cr, args[1]);
        Lib_Error.ifEmpty(cr, reply, "Reply");
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("reply", reply);
        Object json = this.bricklinkGet(cr, BL_METHOD.POST, "/feedback/" + no + "/reply", this.auth, null, requestBody);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object getColors(CallRuntime cr) {
        cr.args();
        Object json = this.bricklinkGet(cr, BL_METHOD.GET, "/colors", this.auth, null, null);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object getColor(CallRuntime cr) {
        I_Object[] args = cr.args(this, A_IntNumber.class);
        String no = Lib_Convert.getStringValue(cr, args[0]);
        Object json = this.bricklinkGet(cr, BL_METHOD.GET, "/colors/" + no, this.auth, null, null);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object getCategories(CallRuntime cr) {
        cr.args();
        String urlGet = "/categories";
        Object json = this.bricklinkGet(cr, BL_METHOD.GET, "/categories", this.auth, null, null);
        MTable<I_Object> tab = new MTable<I_Object>(3);
        ArrayList arr = (ArrayList)json;
        Object[] objectArray = arr.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            tab.add((I_Object[])new I_Object[]{Lib_Json.jsonToJMo(((HashMap)item).get("category_id")), Lib_Json.jsonToJMo(((HashMap)item).get("parent_id")), Lib_Json.jsonToJMo(((HashMap)item).get("category_name"))});
            ++n2;
        }
        return new JMo_Table(tab);
    }

    private I_Object getCategory(CallRuntime cr) {
        I_Object par1 = cr.args(this, A_IntNumber.class)[0];
        int id = Lib_Convert.getIntValue(cr, par1);
        String urlGet = "/categories/" + id;
        Object json = this.bricklinkGet(cr, BL_METHOD.GET, urlGet, this.auth, null, null);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object getCoupons(CallRuntime cr, boolean in) {
        I_Object[] args = cr.argsFlex(this, 0, 1);
        HashMap<String, String> urlProps = new HashMap<String, String>();
        urlProps.put("direction", in ? "in" : "out");
        if (args.length == 1) {
            BricklinkIncExc statusIE = new BricklinkIncExc(cr, args[0]);
            statusIE.check(value -> Lib_Bricklink.checkCouponState(cr, value));
            if (statusIE.hasItems()) {
                urlProps.put("status", ConvSequence.toText(",", statusIE.generate()));
            }
        }
        Object json = this.bricklinkGet(cr, BL_METHOD.GET, "/coupons", this.auth, urlProps, null);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object getCoupon(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        String no = Lib_Convert.getStringValue(cr, arg);
        Object json = this.bricklinkGet(cr, BL_METHOD.GET, "/coupons/" + no, this.auth, null, null);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object createCoupon(CallRuntime cr) {
        JMo_Map requestData = (JMo_Map)cr.args(this, JMo_Map.class)[0];
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        for (Map.Entry<I_Object, I_Object> e : requestData.copyToHashMap().entrySet()) {
            requestBody.put(Lib_Convert.getStringValue(cr, e.getKey()), Lib_Java.jmoToJava(e.getValue()));
        }
        Object json = this.bricklinkGet(cr, BL_METHOD.POST, "/coupons", this.auth, null, requestBody);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object deleteCoupon(CallRuntime cr) {
        I_Object args = cr.args(this, A_IntNumber.class)[0];
        String id = Lib_Convert.getStringValue(cr, args);
        Object json = this.bricklinkGet(cr, BL_METHOD.DELETE, "/coupons/" + id, this.auth, null, null);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object getShippingMethodList(CallRuntime cr) {
        cr.args();
        Object json = this.bricklinkGet(cr, BL_METHOD.GET, "/settings/shipping_methods", this.auth, null, null);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object getShippingMethod(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        String mid = Lib_Convert.getStringValue(cr, arg);
        Object json = this.bricklinkGet(cr, BL_METHOD.GET, "/settings/shipping_methods/" + mid, this.auth, null, null);
        return Lib_Json.jsonToJMo(json);
    }

    private I_Object getMemberRating(CallRuntime cr) {
        I_Object arg = cr.args(this, Str.class)[0];
        String mid = Lib_Convert.getStringValue(cr, arg);
        Object json = this.bricklinkGet(cr, BL_METHOD.GET, "/members/" + mid + "/ratings", this.auth, null, null);
        return Lib_Json.jsonToJMo(json);
    }

    public Object bricklinkGet(CallRuntime cr, BL_METHOD method, String url, BL_Auth auth, Map<String, String> uri_props, Map<String, Object> request_props) {
        int TRIES = 15;
        ExtError err = null;
        int t = 1;
        while (t <= 15) {
            if (this.limit != null && this.blCallsTotal >= this.limit) {
                throw new ExecError(cr, "Bricklink-Call-Limit reached", "Limit ist set to " + this.limit + " calls.");
            }
            ++this.blCallsTotal;
            try {
                String bl_url = Lib_Bricklink.getBricklinkUrl(cr, method, url, auth, uri_props);
                HttpURLConnection connection = this.iGetConnection(cr, method, bl_url, request_props);
                String result = this.iRead(cr, connection);
                ++this.blCallsSuccess;
                Object json = this.iParseAndCheck(cr, result);
                return json;
            }
            catch (ExtError e) {
                err = e;
                if (!e.getDetail().startsWith("401: BAD_OAUTH_REQUEST / SIGNATURE_INVALID")) {
                    throw e;
                }
                Sys.sleepSeconds(1);
                t = (byte)(t + 1);
            }
        }
        throw err;
    }

    private HttpURLConnection iGetConnection(CallRuntime cr, BL_METHOD method, String url, Map<String, Object> request_props) {
        boolean useProxy = this.proxyURL != null;
        try {
            URL server = new URL(useProxy ? this.proxyURL : url);
            HttpURLConnection connection = (HttpURLConnection)server.openConnection();
            for (Map.Entry<String, String> entry : this.httpPropertys.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            if (useProxy) {
                connection.setRequestProperty(this.proxyKey, url);
            }
            if (method != BL_METHOD.GET) {
                String jsonInputString;
                connection.setRequestMethod(method.getString());
                connection.setRequestProperty("content-type", "application/json");
                connection.setDoOutput(true);
                String string = jsonInputString = request_props == null ? null : Json.serialize(request_props);
                if (jsonInputString != null) {
                    OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream());
                    out.write(jsonInputString);
                    out.close();
                }
            }
            return connection;
        }
        catch (IOException e) {
            throw new ExecError(cr, "Verbindungsfehler", e.getMessage());
        }
    }

    private Object iParseAndCheck(CallRuntime cr, String result) {
        HashMap jsonObject;
        try {
            jsonObject = (HashMap)Json.parse(result);
        }
        catch (ParseException e) {
            throw new ExtError(cr, "BrickLink JSON-Parse-Error", e.getMessage());
        }
        HashMap meta = (HashMap)jsonObject.get("meta");
        long resultCode = (Long)meta.get("code");
        if (resultCode == 404L) {
            return null;
        }
        if (resultCode < 200L || resultCode > 299L) {
            throw new ExtError(cr, "BrickLink-Error", String.valueOf(resultCode) + ": " + meta.get("message") + " / " + meta.get("description"));
        }
        return jsonObject.get("data");
    }

    private String iRead(CallRuntime cr, HttpURLConnection connection) {
        try {
            int i;
            connection.connect();
            InputStream is = connection.getInputStream();
            InputStreamReader r = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(r);
            StringBuffer sb = new StringBuffer();
            while ((i = br.read()) != -1) {
                sb.append((char)i);
            }
            br.close();
            connection.disconnect();
            return sb.toString();
        }
        catch (IOException e) {
            throw new ExecError(cr, "Verbindungsfehler", e.getMessage());
        }
    }
}

