/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.edit.editor.context;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jaymo_lang.edit.action.EVENTS;
import org.jaymo_lang.edit.action.JayMo_Actions;
import org.jaymo_lang.edit.editor.CodeEditor;

public class EditorContextMenu
extends JPopupMenu {
    private static final long serialVersionUID = -3044248699038465912L;
    private final Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private final CodeEditor editor;
    private final JayMo_Actions actions;
    private final JMenuItem undo;
    private final JMenuItem redo;
    private final JMenuItem cut;
    private final JMenuItem copy;
    private final JMenuItem paste;
    private final JMenuItem selectAll;
    private final JMenuItem selectNone;
    private final JMenuItem refactoring;

    private EditorContextMenu(CodeEditor editor, JayMo_Actions actions) {
        this.editor = editor;
        this.actions = actions;
        this.undo = this.addItem("Undo", EVENTS.UNDO, 90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
        this.redo = this.addItem("Redo", EVENTS.REDO, 89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
        this.add(new JSeparator());
        this.cut = this.addItem("Cut", EVENTS.CUT, 88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
        this.copy = this.addItem("Copy", EVENTS.COPY, 67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
        this.paste = this.addItem("Paste", EVENTS.PASTE, 86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
        this.add(new JSeparator());
        this.selectAll = this.addItem("Select All", EVENTS.SELECT_ALL, 65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
        this.selectNone = this.addItem("Select None", EVENTS.SELECT_NONE, 65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() + 64);
        this.add(new JSeparator());
        this.refactoring = this.addItem("Refactoring", EVENTS.REFACTORING, 82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
    }

    public static void addTo(CodeEditor textComponent, JayMo_Actions actions) {
        final EditorContextMenu m = new EditorContextMenu(textComponent, actions);
        textComponent.setComponentPopupMenu(m);
        textComponent.setInheritsPopupMenu(true);
        m.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                m.update();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    private JMenuItem addItem(String title, EVENTS event, int key, int keyMask) {
        JMenuItem item = new JMenuItem(title);
        item.setEnabled(false);
        item.setAccelerator(KeyStroke.getKeyStroke(key, keyMask));
        item.addActionListener(ev -> this.actions.perform(event));
        return this.add(item);
    }

    private void update() {
        this.editor.requestFocus();
        String selectedText = this.editor.getSelectedText();
        String text = this.editor.getText();
        boolean enableCopyCut = selectedText != null && selectedText.length() > 0;
        boolean enablePaste = this.clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor) && this.editor.isEnabled();
        boolean textAvailable = text != null && text.length() > 0;
        boolean hasSelection = this.editor.getSelectionStart() != this.editor.getSelectionEnd();
        this.cut.setEnabled(enableCopyCut);
        this.copy.setEnabled(enableCopyCut);
        this.paste.setEnabled(enablePaste);
        this.selectAll.setEnabled(textAvailable);
        this.selectNone.setEnabled(hasSelection);
        this.selectNone.setVisible(hasSelection);
        this.refactoring.setEnabled(textAvailable);
        this.undo.setEnabled(this.editor.getHistory().canUndo());
        this.redo.setEnabled(this.editor.getHistory().canRedo());
    }
}

