/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.struct;

import de.mn77.base.data.Lib_Random;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.type.Lib_Compare;
import de.mn77.base.error.Err;
import java.util.ArrayList;
import java.util.Collection;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.I_AutoBlockDo;
import org.jaymo_lang.model.I_AutoBlockList;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.model.ObjectManager;
import org.jaymo_lang.model.VarArgsCallBuffer;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.JMo_RegEx;
import org.jaymo_lang.object.LoopHandle;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.I_AtomicValue;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.Nil;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.passthrough.Var;
import org.jaymo_lang.object.pseudo.Return;
import org.jaymo_lang.object.pseudo.VarLet;
import org.jaymo_lang.object.struct.A_Sequence;
import org.jaymo_lang.object.struct.I_DeepGetSet;
import org.jaymo_lang.object.struct.JMo_Map;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;
import org.jaymo_lang.util.Lib_Exec;
import org.jaymo_lang.util.Lib_Output;
import org.jaymo_lang.util.Lib_Sequence;
import org.jaymo_lang.util.Lib_StrFormat;
import org.jaymo_lang.util.Lib_Type;

public class JMo_List
extends A_Sequence
implements I_AutoBlockDo,
I_AutoBlockList {
    private ArrayList<I_Object> list;
    private final VarArgsCallBuffer init;
    private boolean fixedLength = false;
    private boolean fixedTypes = false;
    private boolean fixedValues = false;
    private String fixedType = null;

    public JMo_List() {
        this.list = new ArrayList();
        this.init = null;
    }

    public JMo_List(ArrayList<I_Object> list) {
        this.list = list;
        this.init = null;
    }

    public JMo_List(I_Object[] oa) {
        this.list = new ArrayList();
        I_Object[] i_ObjectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            this.list.add(o);
            ++n2;
        }
        this.init = null;
    }

    public JMo_List(Call ... ca) {
        this.list = null;
        this.init = new VarArgsCallBuffer(ca);
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.list != null && this.init == null) {
            int i = 0;
            while (i < this.list.size()) {
                this.list.set(i, Lib_Convert.getValue(cr, this.list.get(i)));
                ++i;
            }
            return;
        }
        if (this.init != null) {
            I_Object[] ios;
            this.list = new ArrayList();
            I_Object[] i_ObjectArray = ios = this.init.init(cr, this);
            int n = ios.length;
            int n2 = 0;
            while (n2 < n) {
                I_Object o = i_ObjectArray[n2];
                this.list.add(o);
                ++n2;
            }
        }
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "+": 
            case "merge": {
                return A_Object.stdResult(this.mMerge(cr));
            }
            case "-": 
            case "sub": {
                return A_Object.stdResult(this.mSubtract(cr));
            }
            case "*": 
            case "mul": {
                return A_Object.stdResult(this.mMultiply(cr));
            }
            case "/": 
            case "div": {
                return A_Object.stdResult(this.mDivide(cr));
            }
            case "concat": 
            case "++": 
            case "join": {
                return A_Object.stdResult(this.mConcat(cr));
            }
            case "--": 
            case "without": {
                return A_Object.stdResult(this.mWithout(cr));
            }
            case "append": 
            case "add": {
                return A_Object.stdResult(this.mAdd(cr));
            }
            case "delete": {
                return A_Object.stdResult(this.mRemovePos(cr));
            }
            case "remove": {
                return A_Object.stdResult(this.mRemoveItems(cr));
            }
            case "insert": {
                return A_Object.stdResult(this.mInsert(cr));
            }
            case "begin": {
                return A_Object.stdResult(this.mBegin(cr));
            }
            case "clear": {
                return A_Object.stdResult(this.mClear(cr));
            }
            case "swap": {
                return A_Object.stdResult(this.mSwap(cr));
            }
            case "adjust": {
                return A_Object.stdResult(this.mAdjust(cr));
            }
            case "addAll": {
                return A_Object.stdResult(this.mAddAll(cr));
            }
            case "subAll": 
            case "removeAll": {
                return A_Object.stdResult(this.mRemoveAll(cr));
            }
            case "slice": 
            case "intersect": {
                return A_Object.stdResult(this.mSlice(cr));
            }
            case "init": {
                this.mInitList(cr);
                return A_Object.stdResult(this);
            }
            case "shuffle": {
                return A_Object.stdResult(this.mShuffle(cr));
            }
            case "reverse": {
                return A_Object.stdResult(this.mReverse(cr));
            }
            case "uniq": {
                return A_Object.stdResult(this.mUniq(cr));
            }
            case "only": {
                return A_Object.stdResult(this.mOnly(cr));
            }
            case "has": 
            case "knows": {
                return A_Object.stdResult(this.mKnows(cr));
            }
            case "search": 
            case "searchFirst": {
                return A_Object.stdResult(this.mSearch(cr, true));
            }
            case "searchLast": {
                return A_Object.stdResult(this.mSearch(cr, false));
            }
            case "each": {
                return this.mEach(cr);
            }
            case "eachVertical": {
                return this.mEachVertical(cr);
            }
            case "implode": {
                return A_Object.stdResult(this.mImplode(cr));
            }
            case "unfold": {
                return A_Object.stdResult(this.mUnfold(cr));
            }
            case "flatten": {
                return A_Object.stdResult(this.mFlatten(cr));
            }
            case "format": {
                return A_Object.stdResult(this.mFormat(cr));
            }
            case "min": {
                return A_Object.stdResult(this.mMin(cr));
            }
            case "max": {
                return A_Object.stdResult(this.mMax(cr));
            }
            case "sum": {
                return A_Object.stdResult(this.mSum(cr));
            }
            case "average": 
            case "avg": {
                return A_Object.stdResult(this.mAverage(cr));
            }
            case "count": {
                return A_Object.stdResult(this.mCount(cr));
            }
            case "cut": {
                return A_Object.stdResult(this.mCut(cr));
            }
            case "area": {
                return A_Object.stdResult(this.mArea(cr));
            }
            case "end": {
                return A_Object.stdResult(this.mEndPos(cr));
            }
            case "left": {
                return A_Object.stdResult(this.mLeft(cr));
            }
            case "right": {
                return A_Object.stdResult(this.mRight(cr));
            }
            case "start": {
                return A_Object.stdResult(this.mStartPos(cr));
            }
            case "filter": {
                return A_Object.stdResult(this.mFilter(cr, method));
            }
            case "map": {
                return A_Object.stdResult(this.mMap(cr, method));
            }
            case "sort": {
                return A_Object.stdResult(this.mSort(cr, method));
            }
            case "reduce": {
                return A_Object.stdResult(this.mReduce(cr, method));
            }
            case "amount": {
                return A_Object.stdResult(this.mAmount(cr, method));
            }
            case "fixLength": {
                cr.args();
                this.fixedLength = true;
                return A_Object.stdResult(this);
            }
            case "fixTypes": {
                cr.args();
                this.fixedTypes = true;
                return A_Object.stdResult(this);
            }
            case "fixType": {
                this.mFixType(cr);
                return A_Object.stdResult(this);
            }
            case "fix": {
                this.fixedLength = true;
                this.fixedTypes = true;
                return A_Object.stdResult(this);
            }
            case "readOnly": {
                cr.args();
                this.readOnly();
                return A_Object.stdResult(this);
            }
            case "toMap": {
                return A_Object.stdResult(this.mToMap(cr));
            }
            case "store": {
                return A_Object.stdResult(this.mStore(cr));
            }
        }
        return null;
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        return this.mEach((CallRuntime)cr).obj;
    }

    @Override
    public ArrayList<I_Object> autoBlockToList(CallRuntime cr) {
        return this.list;
    }

    public ArrayList<I_Object> getInternalCollection() {
        return this.list;
    }

    @Override
    public boolean equals(Object obj) {
        return this.iEquals(obj, false);
    }

    @Override
    public boolean equalsLazy(Object obj) {
        return this.iEquals(obj, true);
    }

    public void readOnly() {
        this.fixedLength = true;
        this.fixedTypes = true;
        this.fixedValues = true;
    }

    public void internalAdd(I_Object o) {
        if (this.fixedLength) {
            Err.forbidden(o);
        }
        this.list.add(o);
    }

    private Bool mKnows(CallRuntime cr) {
        I_Object o = cr.args(this, I_Object.class)[0];
        for (I_Object lo : this.list) {
            if (!lo.equals(o)) continue;
            return Bool.TRUE;
        }
        return Bool.FALSE;
    }

    private I_Atomic mSearch(CallRuntime cr, boolean first) {
        I_Object o = cr.args(this, I_Object.class)[0];
        if (first) {
            int i = 0;
            while (i < this.list.size()) {
                if (this.list.get(i).compareTo(cr, o) == 0) {
                    return new Int(i + 1);
                }
                ++i;
            }
        } else {
            int i = this.list.size() - 1;
            while (i >= 0) {
                if (this.list.get(i).compareTo(cr, o) == 0) {
                    return new Int(i + 1);
                }
                --i;
            }
        }
        return Nil.NIL;
    }

    @Override
    protected int sequenceSize() {
        return this.list.size();
    }

    @Override
    protected String toStringIdent() {
        String out = this.toString();
        return out.length() <= 40 ? out : "List<" + this.list.size() + '>';
    }

    @Override
    protected String toString2() {
        return this.iToString(false, null);
    }

    @Override
    public String toStringDescribe(CallRuntime cr) {
        return this.iToString(true, cr);
    }

    private String iToString(boolean describe, CallRuntime cr) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (this.list != null) {
            for (I_Object o : this.list) {
                if (describe) {
                    String s = o == this ? "self" : o.toStringDescribe(cr);
                    sb.append(Lib_Output.indentLines(s, false));
                } else {
                    sb.append(o == this ? "self" : o.toString(true));
                }
                sb.append(',');
            }
            Lib_Output.removeEnd(sb, ',');
        }
        sb.append(']');
        return sb.toString();
    }

    private JMo_List mMerge(CallRuntime cr) {
        I_Object other = cr.args(this, I_Object.class)[0];
        ArrayList<I_Object> newList = new ArrayList<I_Object>();
        newList.addAll(this.list);
        newList.add(other);
        return new JMo_List(newList);
    }

    private JMo_List mSubtract(CallRuntime cr) {
        I_Object other = cr.args(this, I_Object.class)[0];
        ArrayList<I_Object> newList = new ArrayList<I_Object>();
        for (I_Object o : this.list) {
            if (o.equals(other)) continue;
            newList.add(o);
        }
        return new JMo_List(newList);
    }

    private JMo_List mDivide(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int divisor = Lib_Convert.getIntValue(cr, arg);
        ArrayList<I_Object> newList = new ArrayList<I_Object>();
        int len = this.list.size();
        if (len % divisor != 0) {
            throw new ExecError(cr, "Invalid length of list", "A List can only divided in equal peaces! " + len + " / " + divisor + " = " + len / divisor);
        }
        int part = len / divisor;
        ArrayList<I_Object> partList = null;
        for (I_Object o : this.list) {
            if (partList == null) {
                partList = new ArrayList<I_Object>();
            }
            partList.add(o);
            if (partList.size() != part) continue;
            newList.add(new JMo_List(partList));
            partList = null;
        }
        return new JMo_List(newList);
    }

    private JMo_List mAdd(CallRuntime cr) {
        I_Object[] oa = cr.argsVar(this, 1, 0);
        this.iFixedLength(cr);
        this.iFixedType(cr, oa);
        I_Object[] i_ObjectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            this.list.add(o);
            ++n2;
        }
        return this;
    }

    private JMo_List mMultiply(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int value = Lib_Convert.getIntValue(cr, arg);
        Lib_Error.ifTooSmall(cr, 1L, value);
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        int i = 0;
        while (i < value) {
            result.add(new JMo_List((ArrayList)this.list.clone()));
            ++i;
        }
        return new JMo_List(result);
    }

    private JMo_List mInsert(CallRuntime cr) {
        I_Object[] oa = cr.args(this, null, A_IntNumber.class);
        this.iFixedLength(cr);
        this.iFixedType(cr, oa);
        int pos = Lib_Convert.getIntValue(cr, oa[1]);
        int len = this.list.size();
        Lib_Error.ifIs(cr, 0, pos, "position");
        Lib_Error.ifOutOfBounds(cr, len + 1, pos, "position");
        if (pos == len + 1) {
            this.list.add(oa[0]);
        } else if (pos < 0) {
            this.list.add(len + pos + 1, oa[0]);
        } else {
            this.list.add(pos - 1, oa[0]);
        }
        return this;
    }

    private JMo_List mBegin(CallRuntime cr) {
        I_Object o = cr.args(this, new Class[]{null})[0];
        this.iFixedLength(cr);
        this.iFixedType(cr, o);
        this.list.add(0, o);
        return this;
    }

    private JMo_List mArea(CallRuntime cr) {
        I_Object[] oa = cr.args(this, Int.class, Int.class);
        int start = ((Int)oa[0]).getValue();
        int end = ((Int)oa[1]).getValue();
        int size = this.list.size();
        Lib_Error.ifEmpty(cr, this.list.size(), "List");
        Lib_Error.ifNotBetween(cr, 1, Math.min(end, size), start, "start");
        Lib_Error.ifNotBetween(cr, Math.max(1, start), size, end, "end");
        return this.iCutCopy(cr, start, Math.min(this.list.size(), end));
    }

    private JMo_List mConcat(CallRuntime cr) {
        JMo_List list2 = (JMo_List)cr.args(this, JMo_List.class)[0];
        ArrayList<I_Object> newList = new ArrayList<I_Object>();
        newList.addAll(this.list);
        newList.addAll(list2.getInternalCollection());
        return new JMo_List(newList);
    }

    private JMo_List mAddAll(CallRuntime cr) {
        JMo_List list2 = (JMo_List)cr.args(this, JMo_List.class)[0];
        this.iFixedLength(cr);
        if (this.fixedType != null) {
            for (I_Object obj : list2.getInternalCollection()) {
                this.iFixedType(cr, obj);
            }
        }
        this.list.addAll(list2.getInternalCollection());
        return this;
    }

    private JMo_List mRemoveAll(CallRuntime cr) {
        JMo_List list2 = (JMo_List)cr.args(this, JMo_List.class)[0];
        this.iFixedLength(cr);
        this.list.removeAll(list2.list);
        return this;
    }

    private JMo_List mWithout(CallRuntime cr) {
        JMo_List other = (JMo_List)cr.args(this, JMo_List.class)[0];
        Collection<? extends I_Object> other2 = ((A_Sequence)other).getInternalCollection();
        ArrayList<I_Object> newList = new ArrayList<I_Object>();
        for (I_Object o : this.list) {
            if (other2.contains(o)) continue;
            newList.add(o);
        }
        return new JMo_List(newList);
    }

    private JMo_List mSlice(CallRuntime cr) {
        JMo_List list2 = (JMo_List)cr.args(this, JMo_List.class)[0];
        ArrayList<I_Object> list3 = new ArrayList<I_Object>();
        for (I_Object o1 : this.list) {
            if (!list2.list.contains(o1)) continue;
            list3.add(o1);
        }
        return new JMo_List(list3);
    }

    private JMo_Map mToMap(CallRuntime cr) {
        JMo_List keys = (JMo_List)cr.args(this, JMo_List.class)[0];
        return new JMo_Map((ArrayList)keys.list.clone(), (ArrayList)this.list.clone());
    }

    @Override
    protected JMo_List copy(CallRuntime cr) {
        ArrayList copy = (ArrayList)this.list.clone();
        return new JMo_List(copy);
    }

    private JMo_List mCut(CallRuntime cr) {
        I_Object[] oa = cr.args(this, Int.class, Int.class);
        int start = ((Int)oa[0]).getValue();
        int len = ((Int)oa[1]).getValue();
        Lib_Error.ifEmpty(cr, this.list.size(), "List");
        Lib_Error.ifNotBetween(cr, 1, this.list.size(), start, "start");
        if (len == 0) {
            return new JMo_List(new ArrayList<I_Object>());
        }
        if (len > this.list.size()) {
            len = this.list.size() - start + 1;
        }
        return this.iCutCopy(cr, start, Math.min(this.list.size(), start + len - 1));
    }

    private ObjectCallResult mEach(CallRuntime crOld) {
        crOld.args();
        if (crOld.getStream() == null && crOld.getCallBlock() == null) {
            throw new CodeError(crOld, "No Stream or Block for 'each'", null);
        }
        LoopHandle handle = new LoopHandle(this);
        CallRuntime crNew = crOld.copyLoop(handle);
        I_Object result = this;
        for (I_Object it : this.list) {
            handle.startLap();
            result = Lib_Exec.execBlockStream(crNew, it);
            result = Lib_Exec.loopResult(result);
            if (!(result instanceof Return)) continue;
            return ((Return)result).getLoopResult();
        }
        return new ObjectCallResult(result, true);
    }

    private ObjectCallResult mEachVertical(CallRuntime crOld) {
        crOld.args();
        if (crOld.getStream() == null && crOld.getCallBlock() == null) {
            throw new CodeError(crOld, "No Stream or Block for 'eachAll'", null);
        }
        LoopHandle handle = new LoopHandle(this);
        CallRuntime crNew = crOld.copyLoop(handle);
        I_Object result = this;
        int maxItems = 1;
        int pos = 1;
        while (pos <= maxItems) {
            handle.startLap();
            ArrayList<I_Object> cur_al = new ArrayList<I_Object>();
            for (I_Object item : this.list) {
                if ((item = Lib_Convert.getValue(crNew, item)) instanceof I_AutoBlockList) {
                    ArrayList<I_Object> abl = ((I_AutoBlockList)((Object)item)).autoBlockToList(crNew.copyNil());
                    int len = abl.size();
                    if (len > maxItems) {
                        maxItems = len;
                    }
                    Nil o = len >= pos ? abl.get(pos - 1) : Nil.NIL;
                    cur_al.add(o);
                    continue;
                }
                cur_al.add(pos == 1 ? item : Nil.NIL);
            }
            JMo_List cur = new JMo_List(cur_al);
            result = Lib_Exec.execBlockStream(crNew, cur);
            if ((result = Lib_Exec.loopResult(result)) instanceof Return) {
                return ((Return)result).getLoopResult();
            }
            ++pos;
        }
        return new ObjectCallResult(result, true);
    }

    private JMo_List mFilter(CallRuntime cr, String method) {
        Lib_Error.ifArgs(cr.argCount(), 1, (Integer)2, cr, this);
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        int p = 0;
        while (p < this.list.size()) {
            I_Object test = this.list.get(p);
            Bool ok = (Bool)cr.copyEach(method).argsEach(this, 0, new I_Object[]{test}, Bool.class);
            if (ok.getValue().booleanValue()) {
                result.add(test);
            }
            ++p;
        }
        return new JMo_List(result);
    }

    private JMo_List mMap(CallRuntime cr, String method) {
        Lib_Error.ifArgs(cr.argCount(), 1, (Integer)2, cr, this);
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        int p = 0;
        while (p < this.list.size()) {
            I_Object test = this.list.get(p);
            I_Object[] each = new I_Object[]{test};
            I_Object testr = cr.copyEach(method).argsEach(this, 0, each, I_Object.class);
            result.add(testr);
            ++p;
        }
        return new JMo_List(result);
    }

    private I_Object mReduce(CallRuntime cr, String method) {
        Lib_Error.ifArgs(cr.argCount(), 2, (Integer)3, cr, this);
        I_Object sum = cr.argsOneAdvance(this, 0, I_Object.class);
        for (I_Object test : this.list) {
            I_Object[] each = new I_Object[]{sum, test};
            sum = cr.copyEach(method).argsEach(this, 1, each, I_Object.class);
        }
        return sum;
    }

    private Int mAmount(CallRuntime cr, String method) {
        Lib_Error.ifArgs(cr.argCount(), 1, (Integer)2, cr, this);
        int result = 0;
        for (I_Object test : this.list) {
            Bool ok = (Bool)cr.copyEach(method).argsEach(this, 0, new I_Object[]{test}, Bool.class);
            if (!ok.getValue().booleanValue()) continue;
            ++result;
        }
        return new Int(result);
    }

    private JMo_List mUnfold(CallRuntime cr) {
        cr.args();
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        for (I_Object item : this.list) {
            if (item instanceof I_AutoBlockList) {
                ArrayList<I_Object> abl = ((I_AutoBlockList)((Object)item)).autoBlockToList(cr.copyNil());
                for (I_Object o : abl) {
                    result.add(o);
                }
                continue;
            }
            result.add(item);
        }
        return new JMo_List(result);
    }

    private JMo_List mFlatten(CallRuntime cr) {
        cr.args();
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        this.internalFlatten(result, this);
        return new JMo_List(result);
    }

    private void internalFlatten(ArrayList<I_Object> result, JMo_List current) {
        for (I_Object item : current.getInternalCollection()) {
            if (item instanceof JMo_List) {
                this.internalFlatten(result, (JMo_List)item);
                continue;
            }
            result.add(item);
        }
    }

    @Override
    protected I_Object getFirst(CallRuntime cr) {
        return this.list.size() == 0 ? Nil.NIL : this.list.get(0);
    }

    @Override
    protected I_Object getLast(CallRuntime cr) {
        int len = this.list.size();
        return len == 0 ? Nil.NIL : this.list.get(len - 1);
    }

    private JMo_List mStartPos(CallRuntime cr) {
        I_Object o = cr.args(this, Int.class)[0];
        int arg = ((Int)o).getValue();
        int size = this.list.size();
        Lib_Error.ifNotBetween(cr, 1, size, arg, "position");
        return this.iCutCopy(cr, arg, size);
    }

    @Override
    protected I_Object mSequenceGetPull(CallRuntime cr, boolean lazy) {
        I_Object[] oa = cr.argsVar(this, 1, 0);
        if (oa.length == 1) {
            I_AtomicValue oav = (I_AtomicValue)cr.argType(oa[0], I_AtomicValue.class);
            int oi = Lib_Convert.getIntValue(cr, oav);
            int pos = Lib_Sequence.realPos(cr, oi, this.list.size(), lazy);
            return pos == -1 ? Nil.NIL : this.list.get(pos - 1);
        }
        return this.sequenceDeepGet(cr, oa, 0, lazy);
    }

    private Str mImplode(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 0, 1);
        if (args.length == 0) {
            StringBuilder sb = new StringBuilder();
            for (I_Object o : this.list) {
                sb.append(o.toString());
            }
            return new Str(sb.toString());
        }
        I_AtomicValue atomic = (I_AtomicValue)cr.argType(args[0], I_AtomicValue.class);
        String delimiter = Lib_Convert.getStringValue(cr, atomic);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.list.size()) {
            I_Object o = this.list.get(i);
            String s = Lib_Convert.getStringValue(cr, o);
            sb.append(s);
            if (i != this.list.size() - 1) {
                sb.append(delimiter);
            }
            ++i;
        }
        return new Str(sb.toString());
    }

    private void mInitList(CallRuntime cr) {
        I_Object[] args = cr.args(this, A_IntNumber.class, I_Object.class);
        I_Object obj = args[1];
        int num = Lib_Convert.getIntValue(cr, args[0]);
        int i = 0;
        while (i < num) {
            this.list.add(obj);
            ++i;
        }
    }

    private JMo_List mLeft(CallRuntime cr) {
        I_Object o = cr.args(this, Int.class)[0];
        int left = ((Int)o).getValue();
        Lib_Error.ifTooSmall(cr, 0L, left);
        if (left == 0) {
            return new JMo_List(new ArrayList<I_Object>());
        }
        if (left > this.list.size()) {
            return new JMo_List((ArrayList)this.list.clone());
        }
        return this.iCutCopy(cr, 1, Math.min(left, this.list.size()));
    }

    private I_Object mMax(CallRuntime cr) {
        cr.args();
        I_Object result_o = null;
        Double result_d = null;
        for (I_Object o : this.list) {
            double d = Lib_Convert.getDoubleValue(cr, o);
            if (result_o != null && !(d > result_d)) continue;
            result_o = o;
            result_d = d;
        }
        return result_o;
    }

    private I_Object mMin(CallRuntime cr) {
        cr.args();
        I_Object result_o = null;
        Double result_d = null;
        for (I_Object o : this.list) {
            double d = Lib_Convert.getDoubleValue(cr, o);
            if (result_o != null && !(d < result_d)) continue;
            result_o = o;
            result_d = d;
        }
        return result_o;
    }

    private I_Object mAverage(CallRuntime cr) {
        cr.args();
        double result = 0.0;
        for (I_Object o : this.list) {
            double d = Lib_Convert.getDoubleValue(cr, o);
            result += d / (double)this.list.size();
        }
        return new Dec(result);
    }

    private I_Object mCount(CallRuntime cr) {
        I_Object search = cr.args(this, I_Object.class)[0];
        int result = 0;
        for (I_Object o : this.list) {
            if (!o.equals(search)) continue;
            ++result;
        }
        return new Int(result);
    }

    private I_Object mSum(CallRuntime cr) {
        cr.args();
        double result = 0.0;
        for (I_Object o : this.list) {
            result += Lib_Convert.getDoubleValue(cr, o);
        }
        return new Dec(result);
    }

    private JMo_List mOnly(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        int p = 0;
        while (p < this.list.size()) {
            I_Object test = this.list.get(p);
            I_Object[] i_ObjectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String teststr;
                I_Object arg = i_ObjectArray[n2];
                if (arg instanceof JMo_RegEx) {
                    JMo_RegEx regex = (JMo_RegEx)arg;
                    teststr = Lib_Convert.getStringValue(cr, test);
                    if (teststr.matches(regex.getValue())) {
                        result.add(test);
                    }
                } else if (arg instanceof Str) {
                    String search = Lib_Convert.getStringValue(cr, arg);
                    teststr = Lib_Convert.getStringValue(cr, test);
                    if (teststr.equals(search)) {
                        result.add(test);
                    }
                } else if (test.compareTo(cr, arg) == 0) {
                    result.add(test);
                }
                ++n2;
            }
            ++p;
        }
        return new JMo_List(result);
    }

    private JMo_List mRemoveItems(CallRuntime cr) {
        I_Object[] oa = cr.argsVar(this, 1, 0);
        this.iFixedLength(cr);
        I_Object[] i_ObjectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            int i = this.list.size() - 1;
            while (i >= 0) {
                if (this.list.get(i).equals(o)) {
                    this.list.remove(i);
                }
                --i;
            }
            ++n2;
        }
        return this;
    }

    private JMo_List mRemovePos(CallRuntime cr) {
        Int o = (Int)cr.args(this, Int.class)[0];
        this.iFixedLength(cr);
        int oi = Lib_Convert.getIntValue(cr, o);
        Lib_Error.ifNotBetween(cr, 1, this.list.size(), oi, "position");
        this.list.remove(oi - 1);
        return this;
    }

    private JMo_List mClear(CallRuntime cr) {
        cr.args();
        this.iFixedLength(cr);
        this.list.clear();
        return this;
    }

    private JMo_List mSwap(CallRuntime cr) {
        I_Object[] args = cr.args(this, A_IntNumber.class, A_IntNumber.class);
        int pos1 = Lib_Convert.getIntValue(cr, args[0]);
        int pos2 = Lib_Convert.getIntValue(cr, args[1]);
        Lib_Error.ifNotBetween(cr, 1, this.list.size(), pos1, "position 1");
        Lib_Error.ifNotBetween(cr, 1, this.list.size(), pos2, "position 2");
        I_Object buffer = this.list.get(--pos1);
        this.list.set(pos1, this.list.get(--pos2));
        this.list.set(pos2, buffer);
        return this;
    }

    private JMo_List mAdjust(CallRuntime cr) {
        I_Object[] args = cr.args(this, A_IntNumber.class, I_Object.class);
        this.iFixedLength(cr);
        int len = Lib_Convert.getIntValue(cr, args[0]);
        I_Object fill = args[1];
        this.iFixedType(cr, fill);
        Lib_Error.ifTooSmall(cr, 0L, len);
        while (this.list.size() > len) {
            this.list.remove(this.list.size() - 1);
        }
        while (this.list.size() < len) {
            this.list.add(fill);
        }
        return this;
    }

    private JMo_List mReverse(CallRuntime cr) {
        cr.args();
        this.iFixedValues(cr);
        ArrayList<I_Object> dest = new ArrayList<I_Object>();
        for (I_Object o : this.list) {
            dest.add(0, o);
        }
        this.list = dest;
        return this;
    }

    private JMo_List mRight(CallRuntime cr) {
        I_Object o = cr.args(this, Int.class)[0];
        int right = ((Int)o).getValue();
        Lib_Error.ifTooSmall(cr, 0L, right);
        if (right == 0) {
            return new JMo_List(new ArrayList<I_Object>());
        }
        if (right > this.list.size()) {
            return new JMo_List((ArrayList)this.list.clone());
        }
        return this.iCutCopy(cr, Math.max(1, this.list.size() - right + 1), this.list.size());
    }

    @Override
    protected void mSequenceSetPut(CallRuntime cr, boolean lazy) {
        I_Object[] oa = cr.argsVar(this, 2, 1);
        if (oa.length > 2) {
            this.sequenceDeepSet(cr, oa, 1, oa[0], lazy);
        } else {
            this.sequenceSet(cr, oa[1], oa[0], lazy);
        }
    }

    private JMo_List mShuffle(CallRuntime cr) {
        cr.args();
        this.iFixedValues(cr);
        int size = this.list.size();
        int[] rnd = Lib_Random.getIntArraySet(0, size - 1);
        ArrayList<I_Object> dest = new ArrayList<I_Object>(size);
        int[] nArray = rnd;
        int n = rnd.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            dest.add(this.list.get(i));
            ++n2;
        }
        this.list = dest;
        return this;
    }

    private JMo_List mSort(CallRuntime cr, String method) {
        int parCount = cr.argCount();
        Lib_Error.ifArgs(parCount, 0, (Integer)2, cr, this);
        this.iFixedValues(cr);
        if (parCount == 0) {
            cr.args();
            this.list.sort((o1, o2) -> {
                Object so1 = o1;
                Object so2 = o2;
                if (o1 instanceof I_AtomicValue) {
                    so1 = ((I_AtomicValue)o1).getValue();
                }
                if (o2 instanceof I_AtomicValue) {
                    so2 = ((I_AtomicValue)o2).getValue();
                }
                return Lib_Compare.isEqual(so1, so2) ? 0 : (Lib_Compare.isGreater(so1, so2) ? 1 : -1);
            });
            return this;
        }
        int l = 1;
        while (l < this.list.size()) {
            int smallest = l;
            int m = l + 1;
            while (m <= this.list.size()) {
                I_Object buffer1 = this.list.get(smallest - 1);
                I_Object buffer2 = this.list.get(m - 1);
                I_Object[] test = new I_Object[]{buffer1, buffer2};
                Bool correct = (Bool)cr.copyEach(method).argsEach(this, 0, test, Bool.class);
                if (!correct.getValue().booleanValue()) {
                    smallest = m;
                }
                ++m;
            }
            if (l != smallest) {
                int pos1 = smallest - 1;
                int pos2 = l - 1;
                I_Object buffer1 = this.list.get(pos1);
                I_Object buffer2 = this.list.get(pos2);
                this.list.set(pos1, buffer2);
                this.list.set(pos2, buffer1);
            }
            ++l;
        }
        return this;
    }

    private JMo_List mEndPos(CallRuntime cr) {
        I_Object o = cr.args(this, Int.class)[0];
        int arg = ((Int)o).getValue();
        Lib_Error.ifNotBetween(cr, 1, this.list.size(), arg, "position");
        return this.iCutCopy(cr, 1, arg);
    }

    private JMo_List mUniq(CallRuntime cr) {
        cr.args();
        this.iFixedLength(cr);
        int p = 0;
        while (p < this.list.size() - 1) {
            I_Object search = this.list.get(p);
            int q = this.list.size() - 1;
            while (q > p) {
                if (this.list.get(q).equals(search)) {
                    this.list.remove(q);
                }
                --q;
            }
            ++p;
        }
        return this;
    }

    private JMo_List mStore(CallRuntime cr) {
        I_Object[] args = cr.getArgs(this);
        if (args.length != this.list.size()) {
            throw new CodeError(cr, "Invalid amount of arguments", "Got " + args.length + ", need equal to listsize: " + this.list.size());
        }
        int pi = 0;
        while (pi < this.list.size()) {
            I_Object arg = cr.argTypeExt(args[pi], VarLet.class, Nil.class);
            if (!(arg instanceof Nil)) {
                Var v = ((VarLet)arg).getVar();
                v.let(cr, cr, this.list.get(pi));
            }
            ++pi;
        }
        return this;
    }

    private Str mFormat(CallRuntime cr) {
        String form = ((Str)cr.args(this, Str.class)[0]).getValue();
        int listPos = 0;
        int formPos = 0;
        StringBuilder sb = new StringBuilder();
        while (formPos < form.length()) {
            Group2<Boolean, String> part = Lib_StrFormat.getNext(form, formPos);
            formPos += ((String)part.o2).length();
            if (!((Boolean)part.o1).booleanValue() || listPos >= this.list.size()) {
                sb.append((String)part.o2);
                continue;
            }
            sb.append(Lib_StrFormat.format(cr, (String)part.o2, this.list.get(listPos++)));
        }
        return new Str(sb.toString());
    }

    private void mFixType(CallRuntime cr) {
        Str o = (Str)cr.args(this, Str.class)[0];
        String type = Lib_Convert.getStringValue(cr, o);
        if (!ObjectManager.isTypeKnown(cr, type)) {
            throw new ExecError(cr, "Unknown type", "Unknown type: <" + type + '>');
        }
        this.fixedType = type;
        int counter = 0;
        for (I_Object item : this.list) {
            ++counter;
            if (Lib_Type.isInstanceOf(item, this.fixedType)) continue;
            String sTypes = "<" + item.getTypeName() + '>';
            throw new ExecError(cr, "Invalid type of item in list", "Type <" + this.fixedType + "> needed, but type of item at position " + counter + " is: " + sTypes);
        }
    }

    private JMo_List iCutCopy(CallRuntime cr, int start, int end) {
        Lib_Error.ifTooSmall(cr, start, end);
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        int i = start - 1;
        while (i < end) {
            result.add(this.list.get(i));
            ++i;
        }
        return new JMo_List(result);
    }

    private void iFixedValues(CallRuntime cr) {
        if (this.fixedValues) {
            throw new ExecError(cr, "This List is read only", "Changes are not allowed!");
        }
    }

    private void iFixedLength(CallRuntime cr) {
        if (this.fixedLength) {
            throw new ExecError(cr, "Can't change size of fixed List", "Adding/Removing elements is not allowed!");
        }
    }

    private void iFixedType(CallRuntime cr, I_Object[] oa) {
        if (this.fixedType != null) {
            I_Object[] i_ObjectArray = oa;
            int n = oa.length;
            int n2 = 0;
            while (n2 < n) {
                I_Object obj = i_ObjectArray[n2];
                this.iFixedType(cr, obj);
                ++n2;
            }
        }
    }

    private void iFixedType(CallRuntime cr, I_Object obj) {
        if (this.fixedType != null && !Lib_Type.isInstanceOf(obj, this.fixedType)) {
            throw new ExecError(cr, "Invalid object type for fixed List.", "This List accepts only <" + this.fixedType + ">, but got object with type: " + Lib_Type.getTypeString(obj));
        }
    }

    @Override
    public I_Object sequenceDeepGet(CallRuntime cr, I_Object[] keys, int offset, boolean lazy) {
        A_IntNumber oi = (A_IntNumber)cr.argType(keys[offset], A_IntNumber.class);
        int i = Lib_Convert.getIntValue(cr, oi);
        int pos = Lib_Sequence.realPos(cr, i, this.list.size(), lazy);
        if (pos == -1 || pos > this.list.size()) {
            if (lazy) {
                return Nil.NIL;
            }
            Lib_Error.ifNotBetween(cr, 1, this.list.size(), pos, "position in list");
        }
        if (offset == keys.length - 1) {
            return this.list.get(pos - 1);
        }
        I_Object deeper = this.list.get(pos - 1);
        if (!(deeper instanceof I_DeepGetSet)) {
            StringBuilder sb = new StringBuilder();
            int j = 0;
            while (j <= offset) {
                if (j > 0) {
                    sb.append(',');
                }
                sb.append(keys[j].toString());
                ++j;
            }
            throw new ExecError(cr, "Invalid type of item.", "Item at position (" + sb.toString() + ") isn't a sequence, so I can't go into it!");
        }
        return ((I_DeepGetSet)((Object)deeper)).sequenceDeepGet(cr, keys, offset + 1, lazy);
    }

    @Override
    public void sequenceDeepSet(CallRuntime cr, I_Object[] keys, int offset, I_Object value, boolean lazy) {
        A_IntNumber oi = (A_IntNumber)cr.argType(keys[offset], A_IntNumber.class);
        int wanted = Lib_Convert.getIntValue(cr, oi);
        if (lazy) {
            while (Math.abs(wanted) > this.list.size()) {
                this.list.add(Nil.NIL);
            }
        }
        int pos = Lib_Sequence.realPos(cr, wanted, this.list.size(), lazy);
        Lib_Error.ifNotBetween(cr, 1, this.list.size(), pos, "position");
        this.iFixedValues(cr);
        if (offset == keys.length - 1) {
            this.list.set(pos - 1, value);
        } else {
            I_Object deeper = this.list.get(pos - 1);
            if (deeper == Nil.NIL && lazy) {
                deeper = new JMo_List();
                this.list.set(pos - 1, deeper);
            }
            if (!(deeper instanceof A_Sequence)) {
                throw new ExecError(cr, "Invalid type of item.", "Item at position " + (offset + 1) + " isn't a sequence, so I can't go into it!");
            }
            A_Sequence deeper2 = (A_Sequence)deeper;
            deeper2.sequenceDeepSet(cr, keys, offset + 1, value, lazy);
        }
    }

    @Override
    protected I_Object sequenceSelectGet(CallRuntime cr, I_Object key, boolean lazy) {
        int oi = Lib_Convert.getIntValue(cr, key);
        int pos = Lib_Sequence.realPos(cr, oi, this.list.size(), lazy);
        return pos == -1 ? Nil.NIL : this.list.get(pos - 1);
    }

    @Override
    protected void sequenceSet(CallRuntime cr, I_Object pos2, I_Object o, boolean lazy) {
        I_Object curObj;
        int wanted = Lib_Convert.getIntValue(cr, pos2);
        if (lazy) {
            while (Math.abs(wanted) > this.list.size()) {
                this.list.add(Nil.NIL);
            }
        }
        int pos = Lib_Sequence.realPos(cr, wanted, this.list.size(), lazy);
        Lib_Error.ifNotBetween(cr, 1, this.list.size(), pos, "position");
        this.iFixedValues(cr);
        if (this.fixedTypes && (curObj = this.list.get(pos - 1)) != Nil.NIL) {
            o = Lib_Type.typeCheck(cr, o, Lib_Type.getName(o), Lib_Type.getName(curObj), "list item");
        }
        this.list.set(pos - 1, o);
    }

    @Override
    protected boolean sequenceEmpty() {
        return this.list.isEmpty();
    }

    private boolean iEquals(Object obj, boolean lazy) {
        if (obj instanceof JMo_List) {
            ArrayList<I_Object> other = ((JMo_List)obj).list;
            if (this.list.size() != other.size()) {
                return false;
            }
            int i = 0;
            while (i < this.list.size()) {
                if (lazy ? !this.list.get(i).equalsLazy(other.get(i)) : !this.list.get(i).equals(other.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

