/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.struct;

import de.mn77.base.data.constant.CONDITION;
import de.mn77.base.error.Err;
import java.util.ArrayList;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.pseudo.FuncLet;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.BLOCKED;
import org.jaymo_lang.util.Lib_Comply;
import org.jaymo_lang.util.Lib_Output;

public class JMo_FunctionMap
extends A_Object {
    private static final String[] BLOCKED_FUNCTION_NAMES = new String[]{"add", "sub", "remove", "clear", "copy", "size", "len", "length", "get", "set", "isEmpty", "keys", "objects", "hasKey", "knowsKey", "hasObject", "knowsObject"};
    private final ArrayList<String> keys;
    private final ArrayList<I_Object> objects;

    public JMo_FunctionMap() {
        this(null, new ArrayList<String>(), new ArrayList<I_Object>());
    }

    public JMo_FunctionMap(CallRuntime cr, ArrayList<String> keys, ArrayList<I_Object> objects) {
        if (keys.size() != objects.size()) {
            Err.direct("Keys and objects have different sizes!", keys.size(), objects.size());
        }
        this.keys = keys;
        this.objects = objects;
        if (keys.size() > 1) {
            for (String key : keys) {
                this.iValidateKey(cr, key, false);
            }
        }
    }

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "add": {
                return A_Object.stdResult(this.mAdd(cr));
            }
            case "remove": 
            case "sub": {
                return A_Object.stdResult(this.mRemove(cr));
            }
            case "clear": {
                return A_Object.stdResult(this.mClear(cr));
            }
            case "copy": {
                return A_Object.stdResult(this.mCopy(cr));
            }
            case "len": 
            case "getLength": {
                return A_Object.stdResult(this.mGetLength(cr));
            }
            case "get": {
                return A_Object.stdResult(this.mGet(cr));
            }
            case "set": {
                return A_Object.stdResult(this.mSet(cr));
            }
            case "isEmpty": {
                return A_Object.stdResult(this.mIsEmpty(cr));
            }
            case "getKeys": {
                return A_Object.stdResult(this.mGetKeys(cr));
            }
            case "getObjects": {
                return A_Object.stdResult(this.mGetObjects(cr));
            }
            case "hasKey": 
            case "knowsKey": {
                return A_Object.stdResult(this.mKnowsKey(cr));
            }
            case "hasObject": 
            case "knowsObject": {
                return A_Object.stdResult(this.mKnowsObject(cr));
            }
        }
        if (!cr.getApp().strict.isValid_ShortenMethod() || method.length() < 3) {
            int index = this.keys.indexOf(method);
            if (index != -1) {
                return this.iExec(cr, this.objects.get(index));
            }
        } else {
            int hit = -1;
            int i = 0;
            while (i < this.keys.size()) {
                if (this.keys.get(i).startsWith(method)) {
                    if (hit == -1) {
                        hit = i;
                    } else {
                        throw new CodeError(cr, "Unclear function name", "Got: " + method);
                    }
                }
                ++i;
            }
            if (method.length() < 3 && this.keys.get(hit).length() != method.length()) {
                throw new CodeError(cr, "To short function name", "Got: " + method);
            }
            if (hit != -1) {
                return this.iExec(cr, this.objects.get(hit));
            }
        }
        return null;
    }

    private Int mGetLength(CallRuntime cr) {
        cr.args();
        return new Int(this.keys.size());
    }

    @Override
    public String toString(boolean nested) {
        if (nested) {
            return this.toStringIdent(null);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("FunctionMap[");
        int i = 0;
        while (i < this.keys.size()) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(String.valueOf('\"') + this.keys.get(i).toString() + '\"');
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String toStringIdent(CallRuntime cr) {
        return String.valueOf(this.getTypeName()) + '<' + this.keys.size() + '>';
    }

    @Override
    public String toStringDescribe(CallRuntime cr) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.keys.size()) {
            String sk = String.valueOf('\"') + this.keys.get(i) + '\"';
            sk = Lib_Output.indentLines(sk, false);
            sb.append(sk);
            sb.append(" -> ");
            String sv = this.objects.get(i).toStringDescribe(cr);
            sv = Lib_Output.indentLines(sv, false);
            sb.append(sv);
            sb.append('\n');
            ++i;
        }
        Lib_Output.removeEnd(sb, '\n');
        return sb.toString();
    }

    private JMo_FunctionMap mAdd(CallRuntime cr) {
        I_Object[] oa = cr.args(this, Str.class, I_Object.class);
        Str key = (Str)oa[0];
        I_Object object = oa[1];
        String name = key.getValue();
        this.iValidateKey(cr, name, true);
        this.keys.add(name);
        this.objects.add(object);
        return this;
    }

    private JMo_FunctionMap mCopy(CallRuntime cr) {
        cr.args();
        ArrayList clonen = (ArrayList)this.keys.clone();
        ArrayList cloneo = (ArrayList)this.objects.clone();
        return new JMo_FunctionMap(cr, clonen, cloneo);
    }

    private I_Object mGet(CallRuntime cr) {
        I_Object[] oa = cr.argsVar(this, 1, 0);
        if (oa.length == 1) {
            Str key = (Str)cr.argType(oa[0], Str.class);
            int idx = this.iGetIndex(cr, key.getValue(), true);
            return this.objects.get(idx);
        }
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        I_Object[] i_ObjectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object key = i_ObjectArray[n2];
            Str skey = (Str)cr.argType(key, Str.class);
            int idx = this.iGetIndex(cr, skey.getValue(), true);
            I_Object g = this.objects.get(idx);
            result.add(g);
            ++n2;
        }
        return new JMo_List(result);
    }

    private JMo_List mGetKeys(CallRuntime cr) {
        cr.args();
        ArrayList<I_Object> clone = new ArrayList<I_Object>();
        for (String s : this.keys) {
            clone.add(new Str(s));
        }
        return new JMo_List(clone);
    }

    private JMo_List mGetObjects(CallRuntime cr) {
        cr.args();
        ArrayList clone = (ArrayList)this.objects.clone();
        return new JMo_List(clone);
    }

    private Bool mIsEmpty(CallRuntime cr) {
        cr.args();
        return Bool.getObject(this.keys.size() == 0);
    }

    private Bool mKnowsKey(CallRuntime cr) {
        Str search = (Str)cr.args(this, Str.class)[0];
        int idx = this.iGetIndex(cr, search.getValue(), false);
        return idx == -1 ? Bool.FALSE : Bool.TRUE;
    }

    private Bool mKnowsObject(CallRuntime cr) {
        I_Object search = cr.args(this, I_Object.class)[0];
        for (I_Object o : this.objects) {
            if (!o.equals(search)) continue;
            return Bool.TRUE;
        }
        return Bool.FALSE;
    }

    private JMo_FunctionMap mRemove(CallRuntime cr) {
        Str key = (Str)cr.args(this, Str.class)[0];
        int i = this.iGetIndex(cr, key.getValue(), true);
        this.keys.remove(i);
        this.objects.remove(i);
        return this;
    }

    private JMo_FunctionMap mClear(CallRuntime cr) {
        cr.args();
        this.keys.clear();
        this.objects.clear();
        return this;
    }

    private JMo_FunctionMap mSet(CallRuntime cr) {
        I_Object[] oa = cr.args(this, Str.class, I_Object.class);
        Str key = (Str)oa[0];
        I_Object value = oa[1];
        int i = this.iGetIndex(cr, key.getValue(), true);
        this.objects.set(i, value);
        return this;
    }

    private int iGetIndex(CallRuntime cr, String key, boolean error) {
        int index = this.keys.indexOf(key);
        if (index >= 0) {
            return index;
        }
        if (error) {
            throw new ExecError(cr, "Unknown keyname", "Got: " + key);
        }
        return -1;
    }

    private void iValidateKey(CallRuntime cr, String key, boolean check_doubles) {
        int index;
        String blocked;
        if (!Lib_Comply.checkFunctionName(key, CONDITION.MAYBE)) {
            throw new ExecError(cr, "Malformed keyname", "Got: " + key);
        }
        String[] stringArray = BLOCKED.FUNCTIONS;
        int n = BLOCKED.FUNCTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            blocked = stringArray[n2];
            if (key.startsWith(blocked)) {
                throw new ExecError(cr, "Forbidden keyname", "Blocked: " + blocked + ", got: " + key);
            }
            ++n2;
        }
        stringArray = BLOCKED_FUNCTION_NAMES;
        n = BLOCKED_FUNCTION_NAMES.length;
        n2 = 0;
        while (n2 < n) {
            blocked = stringArray[n2];
            if (key.startsWith(blocked)) {
                throw new ExecError(cr, "Forbidden keyname", "Blocked: " + blocked + ", got: " + key);
            }
            ++n2;
        }
        if (check_doubles && (index = this.keys.indexOf(key)) != -1) {
            throw new ExecError(cr, "Duplicated keyname", "Got: " + key);
        }
    }

    private ObjectCallResult iExec(CallRuntime cr, I_Object o) {
        if (o instanceof FuncLet) {
            FuncLet fl = (FuncLet)o;
            o = fl.exec(cr);
        }
        return A_Object.stdResult(o);
    }
}

