/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.pseudo;

import de.mn77.base.data.convert.ConvArray;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.magic.var.MV_THIS;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Output;

public class FuncLet
extends A_Object {
    private final Call call;
    private Call[] args = null;
    private String type = null;

    public FuncLet(Call call) {
        this.call = call;
    }

    @Override
    public void init(CallRuntime cr) {
        this.type = cr.getType().getName();
        Call[] cpars = this.call.argCalls;
        if (cpars != null && cpars.length > 0) {
            int len = cpars.length;
            this.args = new Call[len];
            int i = 0;
            while (i < len) {
                Call c = cpars[i];
                I_Object o = cr.execInit(c, this);
                o = Lib_Convert.getValue(cr, o);
                this.args[i] = new Call(cr.getSurrBlock(), o, cr.getDebugInfo());
                ++i;
            }
        }
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "exec": {
                return new ObjectCallResult(this.exec(cr), false);
            }
        }
        return null;
    }

    public I_Object exec(CallRuntime crOld) {
        Call[] execPars = crOld.call.argCalls;
        if (this.args != null) {
            if (execPars != null && execPars.length > 0) {
                throw new CodeError(crOld, "Parameter already set for FuncLet!", "Already set parameters: " + this.args.length);
            }
            execPars = this.args;
        }
        CallRuntime crNew = crOld.copyFunctional(this.call, execPars, crOld.getDebugInfo());
        return crNew.exec(this, false);
    }

    public I_Object eachExec(CallRuntime cr, I_Object obj) {
        Call c = new Call(cr.getSurrBlock(), obj, cr.getDebugInfo());
        CallRuntime cr2 = cr.copyFunctional(c, new Call[]{c}, cr.getDebugInfo());
        return this.exec(cr2);
    }

    @Override
    public String toString(boolean nested) {
        if (nested) {
            return this.getTypeName();
        }
        String ident = this.call.object != null && this.call.object instanceof MV_THIS && this.type != null ? this.type : this.call.object.toStringIdent(null);
        StringBuilder sb = new StringBuilder();
        sb.append(ident);
        sb.append('.');
        sb.append(this.call.method);
        sb.append('(');
        if (this.args != null && this.args.length > 0) {
            Call[] callArray = this.args;
            int n = this.args.length;
            int n2 = 0;
            while (n2 < n) {
                Call arg = callArray[n2];
                sb.append(arg.toStringIdent(null));
                sb.append(',');
                ++n2;
            }
            Lib_Output.removeEnd(sb, ',');
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public String toStringDescribe(CallRuntime cr) {
        StringBuilder sb = new StringBuilder();
        sb.append("FuncLet[");
        if (this.call.object != null && this.call.object instanceof MV_THIS && this.type != null) {
            String p = this.args != null ? ConvArray.toString(",", this.args) : "";
            sb.append(String.valueOf(this.type) + '.' + this.call.method + '(' + p + ')');
        } else {
            sb.append(this.call.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

