/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.immute.datetime;

import de.mn77.base.data.type.datetime.I_Date;
import de.mn77.base.data.type.datetime.I_DateTime;
import de.mn77.base.data.type.datetime.I_Time;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.datetime.A_DateTimeBase;
import org.jaymo_lang.object.immute.datetime.JMo_Date;
import org.jaymo_lang.object.immute.datetime.JMo_Time;
import org.jaymo_lang.object.immute.datetime.Lib_DateTime_Format;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Type;

public class JMo_DateTime
extends A_DateTimeBase {
    private I_DateTime datetime;
    private final ArgCallBuffer[] init;

    public JMo_DateTime(I_DateTime datetime) {
        this.init = null;
        this.datetime = datetime;
    }

    public JMo_DateTime() {
        this.init = null;
        this.datetime = null;
    }

    public JMo_DateTime(Call str) {
        this.init = new ArgCallBuffer[]{new ArgCallBuffer(0, str)};
        this.datetime = null;
    }

    public JMo_DateTime(Call y, Call m, Call d, Call hh, Call mm, Call ss) {
        this.init = new ArgCallBuffer[]{new ArgCallBuffer(0, y), new ArgCallBuffer(1, m), new ArgCallBuffer(2, d), new ArgCallBuffer(3, hh), new ArgCallBuffer(4, mm), new ArgCallBuffer(5, ss)};
        this.datetime = null;
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.init == null) {
            if (this.datetime == null) {
                this.datetime = new MDateTime();
            }
        } else {
            if (this.init.length == 1) {
                String s = Lib_Convert.getStringValue(cr, this.init[0].init(cr, this, Str.class));
                try {
                    this.datetime = new MDateTime(s);
                }
                catch (Err_Runtime err) {
                    throw new ExecError(cr, "Can't create DateTime-Object", String.valueOf(err.getMessage()) + " Got: DateTime(" + s + ")");
                }
            }
            int iy = Lib_Convert.getIntValue(cr, this.init[0].init(cr, this, A_IntNumber.class));
            int im = Lib_Convert.getIntValue(cr, this.init[1].init(cr, this, A_IntNumber.class));
            int id = Lib_Convert.getIntValue(cr, this.init[2].init(cr, this, A_IntNumber.class));
            int ihh = Lib_Convert.getIntValue(cr, this.init[3].init(cr, this, A_IntNumber.class));
            int imm = Lib_Convert.getIntValue(cr, this.init[4].init(cr, this, A_IntNumber.class));
            int iss = Lib_Convert.getIntValue(cr, this.init[5].init(cr, this, A_IntNumber.class));
            try {
                this.datetime = new MDateTime(iy, im, id, ihh, imm, iss);
            }
            catch (Err_Runtime err) {
                throw new ExecError(cr, "Invalid datetime", "DateTime(" + iy + "," + im + "," + id + "," + ihh + "," + imm + "," + iss + ")");
            }
        }
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "getYear": {
                return A_Object.stdResult(this.mGetYear(cr));
            }
            case "getMonth": {
                return A_Object.stdResult(this.mGetMonth(cr));
            }
            case "getDay": {
                return A_Object.stdResult(this.mGetDay(cr));
            }
            case "getHour": 
            case "getHours": {
                return A_Object.stdResult(this.mGetHours(cr));
            }
            case "getMin": 
            case "getMinutes": {
                return A_Object.stdResult(this.mGetMinutes(cr));
            }
            case "getSeconds": 
            case "getSec": {
                return A_Object.stdResult(this.mGetSeconds(cr));
            }
            case "getWeekDay": 
            case "getDayOfWeek": {
                return A_Object.stdResult(this.mGetDayOfWeek(cr));
            }
            case "addSec": 
            case "addSeconds": {
                return A_Object.stdResult(this.mAdd(cr, true));
            }
            case "addMin": 
            case "addMinutes": {
                return A_Object.stdResult(this.mAddMinutes(cr));
            }
            case "addHours": 
            case "addHour": {
                return A_Object.stdResult(this.mAddHours(cr));
            }
            case "addDay": 
            case "addDays": {
                return A_Object.stdResult(this.mAddDays(cr));
            }
            case "addMonth": 
            case "addMonths": {
                return A_Object.stdResult(this.mAddMonths(cr));
            }
            case "addYears": 
            case "addYear": {
                return A_Object.stdResult(this.mAddYears(cr));
            }
            case "subSec": 
            case "subSeconds": {
                return A_Object.stdResult(this.mSub(cr, true));
            }
            case "setDay": {
                return A_Object.stdResult(this.mSetDay(cr));
            }
            case "setMonth": {
                return A_Object.stdResult(this.mSetMonth(cr));
            }
            case "setYear": {
                return A_Object.stdResult(this.mSetYear(cr));
            }
            case "setHour": {
                return A_Object.stdResult(this.mSetHour(cr));
            }
            case "setMinute": {
                return A_Object.stdResult(this.mSetMinute(cr));
            }
            case "setSecond": {
                return A_Object.stdResult(this.mSetSecond(cr));
            }
            case "getDate": {
                return A_Object.stdResult(this.mGetDate(cr));
            }
            case "getTime": {
                return A_Object.stdResult(this.mGetTime(cr));
            }
            case "diffDays": {
                return A_Object.stdResult(this.mDiffDays(cr));
            }
            case "diffHours": {
                return A_Object.stdResult(this.mDiffHours(cr));
            }
            case "diffMinutes": {
                return A_Object.stdResult(this.mDiffMinutes(cr));
            }
            case "diffSeconds": 
            case "diff": {
                return A_Object.stdResult(this.mDiffSeconds(cr));
            }
        }
        return null;
    }

    @Override
    public String toString(boolean nested) {
        if (this.datetime == null) {
            return Lib_Type.getName(this);
        }
        return nested ? String.valueOf(this.datetime.getDate().toString()) + '_' + this.datetime.getTime().toString() : this.datetime.toString();
    }

    @Override
    public String toStringDescribe(CallRuntime cr) {
        return String.valueOf(Lib_Type.getName(this)) + "(\"" + this.datetime.getDate().toString() + "\", \"" + this.datetime.getTime().toString() + "\")";
    }

    @Override
    protected boolean[] mCompare2(CallRuntime cr) {
        JMo_DateTime d = (JMo_DateTime)cr.args(this, JMo_DateTime.class)[0];
        boolean isEqual = this.datetime.isEqual(d.getInternalDateTime());
        boolean isGreater = this.datetime.isGreater(d.getInternalDateTime());
        return new boolean[]{isEqual, isGreater};
    }

    @Override
    public boolean equals(Object arg) {
        return arg instanceof JMo_DateTime ? this.datetime.isEqual(((JMo_DateTime)arg).getInternalDateTime()) : false;
    }

    @Override
    public boolean equalsLazy(Object other) {
        if (other instanceof Str) {
            String s = ((Str)other).getValue();
            return s.equals(this.datetime.toString()) || s.equals(this.datetime.toStringDE());
        }
        return this.equals(other);
    }

    private Int mDiffDays(CallRuntime cr) {
        JMo_DateTime arg = (JMo_DateTime)cr.args(this, JMo_DateTime.class)[0];
        int diff = this.datetime.diffDays(arg.getInternalDateTime());
        return new Int(diff);
    }

    private Int mDiffSeconds(CallRuntime cr) {
        JMo_DateTime arg = (JMo_DateTime)cr.args(this, JMo_DateTime.class)[0];
        int diff = this.datetime.diffSeconds(arg.getInternalDateTime());
        return new Int(diff);
    }

    private Int mDiffMinutes(CallRuntime cr) {
        JMo_DateTime arg = (JMo_DateTime)cr.args(this, JMo_DateTime.class)[0];
        int diff = this.datetime.diffMinutes(arg.getInternalDateTime());
        return new Int(diff);
    }

    private Int mDiffHours(CallRuntime cr) {
        JMo_DateTime arg = (JMo_DateTime)cr.args(this, JMo_DateTime.class)[0];
        int diff = this.datetime.diffHours(arg.getInternalDateTime());
        return new Int(diff);
    }

    private Int mGetDay(CallRuntime cr) {
        cr.args();
        return new Int(this.datetime.getDay());
    }

    private Int mGetMonth(CallRuntime cr) {
        cr.args();
        return new Int(this.datetime.getMonth());
    }

    private Int mGetYear(CallRuntime cr) {
        cr.args();
        return new Int(this.datetime.getYear());
    }

    private Int mGetSeconds(CallRuntime cr) {
        cr.args();
        return new Int(this.datetime.getSeconds());
    }

    private Int mGetMinutes(CallRuntime cr) {
        cr.args();
        return new Int(this.datetime.getMinutes());
    }

    private Int mGetHours(CallRuntime cr) {
        cr.args();
        return new Int(this.datetime.getHours());
    }

    private Int mGetDayOfWeek(CallRuntime cr) {
        cr.args();
        int dow = this.datetime.getDayOfWeek();
        if (dow == 0) {
            dow = 7;
        }
        return new Int(dow);
    }

    private JMo_Date mGetDate(CallRuntime cr) {
        cr.args();
        return new JMo_Date(this.datetime.getDate());
    }

    private JMo_Time mGetTime(CallRuntime cr) {
        cr.args();
        return new JMo_Time(this.datetime.getTime());
    }

    private I_Object mAdd(CallRuntime cr, boolean seconds) {
        I_Object arg;
        I_Object i_Object = arg = seconds ? cr.args(this, A_IntNumber.class)[0] : cr.argsExt(this, new Class[][]{{A_IntNumber.class, JMo_Time.class}})[0];
        if (arg instanceof A_IntNumber) {
            int pari = Lib_Convert.getIntValue(cr, arg);
            I_DateTime date2 = this.datetime.getAddSeconds(pari);
            return new JMo_DateTime(date2);
        }
        if (arg instanceof JMo_Time) {
            int part = ((JMo_Time)arg).getInternalTime().getValueSeconds();
            I_DateTime date2 = this.datetime.getAddSeconds(part);
            return new JMo_DateTime(date2);
        }
        throw Err.impossible(Lib_Type.getName(arg));
    }

    private I_Object mSub(CallRuntime cr, boolean seconds) {
        I_Object arg;
        I_Object i_Object = arg = seconds ? cr.args(this, A_IntNumber.class)[0] : cr.argsExt(this, new Class[][]{{A_IntNumber.class, JMo_Time.class}})[0];
        if (arg instanceof A_IntNumber) {
            int pari = Lib_Convert.getIntValue(cr, arg);
            I_DateTime date2 = this.datetime.getAddSeconds(-pari);
            return new JMo_DateTime(date2);
        }
        if (arg instanceof JMo_Time) {
            int part = ((JMo_Time)arg).getInternalTime().getValueSeconds();
            I_DateTime date2 = this.datetime.getAddSeconds(-part);
            return new JMo_DateTime(date2);
        }
        throw Err.impossible(Lib_Type.getName(arg));
    }

    private JMo_DateTime mAddMinutes(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime date2 = this.datetime.getAddMinutes(pari);
        return new JMo_DateTime(date2);
    }

    private JMo_DateTime mAddHours(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime date2 = this.datetime.getAddHours(pari);
        return new JMo_DateTime(date2);
    }

    private JMo_DateTime mAddDays(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime date2 = this.datetime.getAddDays(pari);
        return new JMo_DateTime(date2);
    }

    private JMo_DateTime mAddMonths(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime date2 = this.datetime.getAddMonths(pari);
        return new JMo_DateTime(date2);
    }

    private JMo_DateTime mAddYears(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime date2 = this.datetime.getAddYears(pari);
        return new JMo_DateTime(date2);
    }

    private JMo_DateTime mSetDay(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime dt2 = this.datetime.getSetDay(pari);
        return new JMo_DateTime(dt2);
    }

    private JMo_DateTime mSetMonth(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime dt2 = this.datetime.getSetMonth(pari);
        return new JMo_DateTime(dt2);
    }

    private JMo_DateTime mSetYear(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime dt2 = this.datetime.getSetYear(pari);
        return new JMo_DateTime(dt2);
    }

    private JMo_DateTime mSetHour(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime dt2 = this.datetime.getSetHour(pari);
        return new JMo_DateTime(dt2);
    }

    private JMo_DateTime mSetMinute(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime dt2 = this.datetime.getSetMinute(pari);
        return new JMo_DateTime(dt2);
    }

    private JMo_DateTime mSetSecond(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime dt2 = this.datetime.getSetSecond(pari);
        return new JMo_DateTime(dt2);
    }

    @Override
    protected A_DateTimeBase incdec2(boolean inc, int amount) {
        if (inc) {
            I_DateTime date2 = this.datetime.getAddSeconds(amount);
            return new JMo_DateTime(date2);
        }
        I_DateTime date2 = this.datetime.getAddSeconds(-amount);
        return new JMo_DateTime(date2);
    }

    @Override
    protected JMo_DateTime mLimit(CallRuntime cr) {
        I_Object[] args = cr.args(this, JMo_DateTime.class, JMo_DateTime.class);
        I_DateTime min = ((JMo_DateTime)args[0]).datetime;
        I_DateTime max = ((JMo_DateTime)args[1]).datetime;
        if (this.datetime.isGreater(max)) {
            return (JMo_DateTime)args[1];
        }
        if (min.isGreater(this.datetime)) {
            return (JMo_DateTime)args[0];
        }
        return this;
    }

    @Override
    protected I_Object mStyle(CallRuntime cr, A_DateTimeBase.COUNTRY country) {
        cr.args();
        switch (country) {
            case DE: {
                return Lib_DateTime_Format.format(cr, "DD.MM.YYYY hh:mm:ss", this.getInternalDate(), this.getInternalTime());
            }
            case EN: {
                return Lib_DateTime_Format.format(cr, "DD/MM/YYYY hh:mm:ss", this.getInternalDate(), this.getInternalTime());
            }
            case US: {
                return Lib_DateTime_Format.format(cr, "M/DD/YYYY i:mm:ss p", this.getInternalDate(), this.getInternalTime());
            }
        }
        throw Err.impossible(new Object[]{country});
    }

    protected I_DateTime getInternalDateTime() {
        return this.datetime;
    }

    @Override
    protected I_Date getInternalDate() {
        return this.datetime.getDate();
    }

    @Override
    protected I_Time getInternalTime() {
        return this.datetime.getTime();
    }

    @Override
    protected I_Object mAddSub(CallRuntime cr, boolean add) {
        return add ? this.mAdd(cr, false) : this.mSub(cr, false);
    }
}

