/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.immute;

import de.mn77.base.error.Err;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.A_Immutable;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Type;

public class JMo_Type
extends A_Immutable {
    private final ArgCallBuffer arg;
    private String name;

    public JMo_Type(Call arg) {
        Err.ifNull(arg);
        this.arg = new ArgCallBuffer(0, arg);
    }

    public JMo_Type(String name, Parser_Script parser) {
        Err.ifNull(name, parser);
        Lib_Type.checkValidity(name, parser);
        this.arg = null;
        this.name = name;
    }

    public JMo_Type(String name, CallRuntime cr) {
        Err.ifNull(name, cr);
        Lib_Type.checkValidity(name, cr);
        this.arg = null;
        this.name = name;
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.arg != null) {
            Str str = (Str)this.arg.init(cr, this, Str.class);
            String typeName = Lib_Convert.getStringValue(cr, str);
            Lib_Type.checkValidity(typeName, cr);
            this.name = typeName;
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "getName": {
                cr.args();
                return A_Object.stdResult(new Str(this.name));
            }
        }
        return null;
    }

    @Override
    public String toString(boolean nested) {
        return "<" + this.name + '>';
    }

    @Override
    public String toStringIdent(CallRuntime cr) {
        return this.toString(false);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof JMo_Type) {
            return ((JMo_Type)other).name.equals(this.name);
        }
        return this == other;
    }

    @Override
    public boolean equalsLazy(Object other) {
        if (other instanceof Str) {
            return ((Str)other).getValue().equals(this.name);
        }
        return this.equals(other);
    }
}

