/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.swing.layout;

import de.mn77.base.data.constant.position.POSITION;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jaymo_lang.lib.graphic.JMo_Color;
import org.jaymo_lang.lib.swing.I_Swing_Object;
import org.jaymo_lang.lib.swing.comp.A_Swing_JComponent;
import org.jaymo_lang.lib.swing.layout.Lib_Layout;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.I_Integer;
import org.jaymo_lang.object.atom.Nil;
import org.jaymo_lang.object.magic.con.MagicPosition;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_Swing_LayoutPanel
extends A_Swing_JComponent
implements I_Swing_Object {
    private final JPanel panel = new JPanel();
    private Border border = null;
    private String title = null;
    private POSITION titlePos = null;

    @Override
    public void init(CallRuntime cr) {
        BorderLayout layout = new BorderLayout();
        this.panel.setLayout(layout);
    }

    @Override
    public Component getSwing() {
        return this.panel;
    }

    @Override
    public I_Object callMethod4(CallRuntime cr, String method) {
        switch (method) {
            case "add": {
                this.add(cr);
                return this;
            }
            case "borderEmpty": 
            case "borderMargin": {
                this.borderEmpty(cr);
                return this;
            }
            case "borderLine": {
                this.borderLine(cr);
                return this;
            }
            case "borderEtchedRaised": 
            case "borderRaisedEtched": {
                this.borderSimple(cr, SIMPLE.ETCHED_RAISED);
                return this;
            }
            case "borderLoweredEtched": 
            case "borderEtchedLowered": {
                this.borderSimple(cr, SIMPLE.ETCHED_LOWERED);
                return this;
            }
            case "borderRaisedBevel": 
            case "borderBevelRaised": {
                this.borderSimple(cr, SIMPLE.BEVEL_RAISED);
                return this;
            }
            case "borderLoweredBevel": 
            case "borderBevelLowered": {
                this.borderSimple(cr, SIMPLE.BEVEL_LOWERED);
                return this;
            }
            case "setTitle": {
                this.setTitle(cr);
                return this;
            }
        }
        return null;
    }

    private void add(CallRuntime cr) {
        I_Swing_Object arg = (I_Swing_Object)cr.args(this, I_Swing_Object.class)[0];
        this.panel.add(arg.getSwing(), "Center");
    }

    private void borderEmpty(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 4);
        int[] trbl = Lib_Layout.border(cr, args);
        this.border = BorderFactory.createEmptyBorder(trbl[0], trbl[3], trbl[2], trbl[1]);
        this.iSet();
    }

    private void borderLine(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 0, 3);
        Color color = Color.black;
        int thickness = 1;
        boolean round = false;
        if (args.length >= 1) {
            color = ((JMo_Color)cr.argType(args[0], JMo_Color.class)).getColor();
        }
        if (args.length >= 2) {
            thickness = Lib_Convert.getIntValue(cr, cr.argType(args[1], I_Integer.class));
        }
        if (args.length == 3) {
            round = Lib_Convert.getBoolValue(cr, cr.argType(args[2], Bool.class));
        }
        this.border = BorderFactory.createLineBorder(color, thickness, round);
        this.iSet();
    }

    private void borderSimple(CallRuntime cr, SIMPLE s) {
        cr.args();
        switch (s) {
            case ETCHED_RAISED: {
                this.border = BorderFactory.createEtchedBorder(0);
                break;
            }
            case ETCHED_LOWERED: {
                this.border = BorderFactory.createEtchedBorder(1);
                break;
            }
            case BEVEL_RAISED: {
                this.border = BorderFactory.createRaisedBevelBorder();
                break;
            }
            case BEVEL_LOWERED: {
                this.border = BorderFactory.createLoweredBevelBorder();
            }
        }
        this.iSet();
    }

    private void setTitle(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 2);
        I_Object arg1 = cr.argType(args[0], I_Atomic.class);
        String string = this.title = arg1 == Nil.NIL ? null : Lib_Convert.getStringValue(cr, arg1);
        if (args.length == 2) {
            MagicPosition pos = (MagicPosition)cr.argType(args[1], MagicPosition.class);
            this.titlePos = pos.get();
        }
        this.iSet();
    }

    @Override
    protected ObjectCallResult callEvent(CallRuntime cr, String event) {
        return null;
    }

    @Override
    protected boolean validateEvent(CallRuntime cr, String event) {
        return false;
    }

    private void iSet() {
        if (this.border == null) {
            this.border = BorderFactory.createEmptyBorder();
        }
        Border toSet = this.border;
        if (this.title != null && this.title.length() != 0) {
            int pos = 0;
            if (this.titlePos != null) {
                if (this.titlePos == POSITION.LEFT) {
                    pos = 1;
                }
                if (this.titlePos == POSITION.RIGHT) {
                    pos = 3;
                }
                if (this.titlePos == POSITION.CENTER) {
                    pos = 2;
                }
            }
            toSet = BorderFactory.createTitledBorder(this.border, this.title, pos, 0);
        }
        this.panel.setBorder(toSet);
    }

    private static enum SIMPLE {
        ETCHED_RAISED,
        ETCHED_LOWERED,
        BEVEL_RAISED,
        BEVEL_LOWERED;

    }
}

