/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.crypt.hash;

import de.mn77.base.error.Err;
import de.mn77.lib.crypt.digest.JAVA_DIGEST;
import de.mn77.lib.crypt.digest.JavaDigest;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.lib.crypt.A_Digest;
import org.jaymo_lang.lib.crypt.Lib_Crypt;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_HashSHA
extends A_Digest {
    private JavaDigest digest;
    private final ArgCallBuffer type;

    public JMo_HashSHA(Call type) {
        this.type = new ArgCallBuffer(0, type);
    }

    @Override
    public void init(CallRuntime cr) {
        JAVA_DIGEST jd = null;
        I_Object typeObj = this.type.init(cr, this, A_IntNumber.class);
        int typeNumber = Lib_Convert.getIntValue(cr, typeObj);
        switch (typeNumber) {
            case 1: {
                jd = JAVA_DIGEST.SHA1;
                break;
            }
            case 256: {
                jd = JAVA_DIGEST.SHA256;
                break;
            }
            case 384: {
                jd = JAVA_DIGEST.SHA384;
                break;
            }
            case 512: {
                jd = JAVA_DIGEST.SHA512;
                break;
            }
            default: {
                throw new ExecError(cr, "Invalid type for SHA-Digest", "Allowed are [1,256,384,512] but got: " + typeNumber);
            }
        }
        this.digest = new JavaDigest(jd);
    }

    @Override
    protected void add(CallRuntime cr, I_Object obj) {
        Object o = Lib_Crypt.add(cr, obj);
        if (o instanceof Byte) {
            this.digest.add((Byte)o);
        } else if (o instanceof byte[]) {
            this.digest.add((byte[])o);
        } else {
            Err.impossible(o);
        }
    }

    @Override
    protected byte[] get() {
        return this.digest.calculate();
    }
}

