/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.edit.editor.funcs;

import de.mn77.base.data.Lib_String;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.group.Group3;
import de.mn77.base.data.group.Section;
import de.mn77.base.error.Err;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.jaymo_lang.edit.editor.funcs.Lib_EditFunctions;
import org.jaymo_lang.util.Lib_Parser;

public class Lib_IndentOutdent {
    public static boolean indent(JTextComponent tp, boolean force) {
        int cursorPos = tp.getCaretPosition();
        int x = tp.getCaret().getMark();
        String text = tp.getText();
        if (cursorPos == x && !force) {
            return Lib_IndentOutdent.iAutoIndent(cursorPos, text, tp);
        }
        if (text.length() == 0) {
            return false;
        }
        Section selection = Lib_EditFunctions.getLines(text, cursorPos, x);
        if (selection != null) {
            if (selection.end < selection.start) {
                return false;
            }
            String part = text.substring(selection.start, selection.end);
            Group2<String, Integer> pa = Lib_IndentOutdent.iIndentReplace(part);
            part = String.valueOf('\t') + (String)pa.o1;
            tp.select(selection.start, selection.end);
            tp.replaceSelection(part);
            if (cursorPos > x) {
                int buf = cursorPos;
                cursorPos = x;
                x = buf;
            }
            tp.select(cursorPos + 1, x + (Integer)pa.o2 + 1);
            return true;
        }
        return false;
    }

    private static Group2<String, Integer> iIndentReplace(String s) {
        int hits = 0;
        boolean openString = false;
        boolean openChar = false;
        StringBuilder sb = new StringBuilder(s.length() + 10);
        int idx = 0;
        while (idx < s.length()) {
            int c = s.charAt(idx);
            if ((openString || openChar) && c == 92) {
                sb.append((char)c);
                c = s.charAt(++idx);
            } else if (c == 34) {
                openString = !openString;
            } else if (c == 39) {
                openChar = !openChar;
            } else if (!openString && !openChar && c == 10) {
                ++hits;
                sb.append((char)c);
                c = 9;
            }
            sb.append((char)c);
            ++idx;
        }
        return new Group2<String, Integer>(sb.toString(), hits);
    }

    public static boolean outdent(JTextComponent tp) {
        int cursorPos = tp.getCaretPosition();
        int x = tp.getCaret().getMark();
        String text = tp.getText();
        Section selection = Lib_EditFunctions.getLines(text, cursorPos, x);
        if (selection != null) {
            String part = text.substring(selection.start, selection.end);
            Group3<String, Integer, Boolean> pa = Lib_IndentOutdent.iOutdentReplace(part);
            part = (String)pa.o1;
            tp.select(selection.start, selection.end);
            tp.replaceSelection(part);
            if (cursorPos > x) {
                int buf = cursorPos;
                cursorPos = x;
                x = buf;
            }
            if (((Boolean)pa.o3).booleanValue()) {
                --cursorPos;
            }
            tp.select(cursorPos, x - (Integer)pa.o2);
            return true;
        }
        return false;
    }

    private static Group3<String, Integer, Boolean> iOutdentReplace(String s) {
        int hits = 0;
        boolean openString = false;
        boolean openChar = false;
        boolean first = true;
        boolean hitFirst = false;
        StringBuilder sb = new StringBuilder(s.length());
        int idx = 0;
        while (idx < s.length()) {
            char c = s.charAt(idx);
            if (first && c == '\t') {
                ++hits;
                hitFirst = true;
                first = false;
            } else {
                first = false;
                if ((openString || openChar) && c == '\\') {
                    sb.append(c);
                    c = s.charAt(++idx);
                } else if (c == '\"') {
                    openString = !openString;
                } else if (c == '\'') {
                    openChar = !openChar;
                } else if (!openString && !openChar && s.startsWith("\n\t", idx)) {
                    ++hits;
                    ++idx;
                }
                sb.append(c);
            }
            ++idx;
        }
        return new Group3<String, Integer, Boolean>(sb.toString(), hits, hitFirst);
    }

    private static boolean iAutoIndent(int cursorPos, String text, JTextComponent tp) {
        String currentText;
        if (text.length() == 0) {
            return false;
        }
        int currentEnd = cursorPos;
        while (currentEnd < text.length()) {
            char cx = text.charAt(currentEnd);
            if (cx == '\n') break;
            if (cx != ' ' && cx != '\t') {
                return false;
            }
            ++currentEnd;
        }
        int currentStart = cursorPos - 1;
        while (currentStart > 0 && text.charAt(currentStart) != '\n') {
            --currentStart;
        }
        if ((currentText = text.substring(++currentStart, currentEnd)).trim().length() > 0) {
            return false;
        }
        int currentIndent = Lib_Parser.getDepth(currentText);
        int beforeStart = currentStart - 2;
        if (beforeStart < 0) {
            beforeStart = 0;
        }
        while (beforeStart > 0 && "\n \t".indexOf(text.charAt(beforeStart)) != -1) {
            --beforeStart;
        }
        while (beforeStart > 0 && text.charAt(beforeStart) != '\n') {
            --beforeStart;
        }
        String beforeText = text.substring(beforeStart + 1);
        int beforeIndent = Lib_Parser.getDepth(beforeText);
        if (currentIndent >= beforeIndent) {
            return false;
        }
        int indentDiff = beforeIndent - currentIndent;
        try {
            tp.getDocument().insertString(cursorPos, Lib_String.sequence('\t', (long)indentDiff), null);
        }
        catch (BadLocationException err) {
            Err.show(err);
        }
        return true;
    }
}

