/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.sys.file;

import de.mn77.base.data.constant.CONDITION;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.stream.Lib_Stream;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.file.MFile;
import de.mn77.base.sys.file.MFileSys;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.ImageIcon;

public class Lib_Jar {
    public static InputStream getStream(String jarPath) throws Err_FileSys {
        Lib_Jar.iCheckLeadingSlash(jarPath, CONDITION.ALWAYS);
        try {
            URL url = Lib_Jar.class.getResource(jarPath);
            if (url == null) {
                Err.fsAccess("File is missing", jarPath);
            }
            return Lib_Jar.class.getResourceAsStream(jarPath);
        }
        catch (Err_FileSys e) {
            throw Lib_Jar.iError(e, jarPath);
        }
    }

    public static File getFileCopy(String jarPath, String jarFilename, String jarSuffix) throws IOException, Err_FileSys {
        if (jarPath.endsWith("/")) {
            jarPath = jarPath.substring(0, jarPath.length() - 1);
        }
        InputStream is = Lib_Jar.getStream(String.valueOf(jarPath) + "/" + jarFilename + "." + jarSuffix);
        MFile tempFile = MFileSys.createTemp(jarFilename, jarSuffix);
        Lib_Stream.connect(is, tempFile.write(), false, true);
        return tempFile.getFile();
    }

    public static ImageIcon getImageIcon(String jarPath) {
        Lib_Jar.iCheckLeadingSlash(jarPath, CONDITION.NEVER);
        return new ImageIcon(Lib_Jar.class.getClassLoader().getResource(jarPath));
    }

    private static void iCheckLeadingSlash(String file, CONDITION leadingSlash) {
        boolean hasLeadingSlash;
        Err.ifEmpty(file);
        boolean bl = hasLeadingSlash = file.charAt(0) == '/';
        if (leadingSlash == CONDITION.ALWAYS && !hasLeadingSlash) {
            Err.invalid(file, "Jar-Path must start with a '/'!");
        }
        if (leadingSlash == CONDITION.NEVER && hasLeadingSlash) {
            Err.invalid(file, "Jar-Path must start without a '/'!");
        }
    }

    private static Err_FileSys iError(Err_FileSys e, String file) {
        MOut.print("File-Error: " + file);
        if (file.indexOf(47) < 0) {
            MOut.print("Maybe used '.' instead of '/' for pathseparator?!");
        }
        e.addDetail(file);
        return e;
    }
}

