/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.runtime;

import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import java.util.HashMap;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.model.ObjectManager;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_DecNumber;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.I_Decimal;
import org.jaymo_lang.object.atom.I_Integer;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_Byte;
import org.jaymo_lang.object.atom.JMo_Float;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.JMo_Short;
import org.jaymo_lang.object.atom.Nil;
import org.jaymo_lang.object.passthrough.Const;
import org.jaymo_lang.object.passthrough.I_VarConst;
import org.jaymo_lang.object.passthrough.Var;
import org.jaymo_lang.object.sys.JMo_Java;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Java;
import org.jaymo_lang.util.Lib_Type;

public class VarEnv {
    private final VarEnv parent;
    private final boolean isConst;
    private HashMap<String, Group2<String, I_Object>> map = null;
    private I_Object itValue = Nil.NIL;

    public VarEnv(VarEnv parent, boolean isConst) {
        this.parent = parent;
        this.isConst = isConst;
    }

    public I_Object get(CallRuntime cr, I_VarConst vc) {
        if (vc.getName().equals("it")) {
            return this.itValue;
        }
        this.init();
        if (this.map.containsKey(vc.getName())) {
            I_Object result = (I_Object)this.map.get((Object)vc.getName()).o2;
            return result == null ? Nil.NIL : result;
        }
        if (this.parent != null && this.parent.knows(vc)) {
            return this.parent.get(cr, vc);
        }
        throw new CodeError(cr, "Access to uninitialized " + this.getTypeString(), vc.getName());
    }

    public I_Object get(CallRuntime cr, I_VarConst vc, I_Object ifNotSet) {
        this.init();
        return this.knows(vc) ? this.get(cr, vc) : ifNotSet;
    }

    public Group2<String, I_Object> getToCopy(String name, DebugInfo debug) {
        if (name.equals("it")) {
            Err.invalid(name);
        }
        this.init();
        if (this.map.containsKey(name)) {
            return this.map.get(name);
        }
        if (this.parent != null) {
            return this.parent.getToCopy(name, debug);
        }
        throw new CodeError("Access to uninitialized " + this.getTypeString(), name, debug);
    }

    public String getType(I_VarConst vc) {
        Group2 g;
        Group2 group2 = g = this.map == null ? null : (Group2)this.map.getOrDefault(vc.getName(), null);
        if (g != null) {
            return (String)g.o1;
        }
        if (this.parent != null) {
            return this.parent.getType(vc);
        }
        return null;
    }

    public void setType(CallRuntime cr, I_VarConst vc, String type) {
        if (!ObjectManager.isTypeKnown(cr, type)) {
            throw new CodeError(cr, "Unknown type name", "Got: '" + type + "'");
        }
        Group2 g = this.map.getOrDefault(vc, null);
        if (g != null) {
            Err.invalid("Type already set!");
        }
        this.map.put(vc.getName(), new Group2<String, Object>(type, null));
    }

    public boolean isInitialized(I_VarConst vc) {
        return this.knows(vc);
    }

    public boolean knows(I_VarConst vc) {
        String name = vc.getName();
        if (name.equals("it")) {
            return true;
        }
        this.init();
        return this.map.containsKey(name) ? true : (this.parent != null ? this.parent.knows(vc) : false);
    }

    public void remove(Var v) {
        if (this.map == null) {
            return;
        }
        this.map.remove(v.getName());
    }

    public void set(CallRuntime cr, I_VarConst vc, I_Object obj, boolean typesafe, boolean nilable, boolean convert) {
        String vcName = vc.getName();
        if (obj == null) {
            throw new CodeError(cr, "No Object to set", vcName);
        }
        if (vcName.equals("it")) {
            this.itValue = Lib_Convert.getValue(cr, obj);
            return;
        }
        this.init();
        if (!this.map.containsKey(vcName) && this.parent != null && this.parent.knows(vc)) {
            this.parent.set(cr, vc, obj, typesafe, nilable, convert);
            return;
        }
        String objType = Lib_Type.getName(obj.getClass(), obj);
        String safedType = null;
        boolean isKnown = this.map.containsKey(vcName);
        if (isKnown) {
            safedType = (String)this.map.get((Object)vcName).o1;
        }
        obj = Lib_Convert.getValue(cr, obj);
        if (vc instanceof Const && this.map.get(vcName) != null && this.map.get((Object)vcName).o2 != null) {
            throw new ExecError(cr, "Constant value is already set and cannot be changed.", String.valueOf(vcName) + "=" + obj.toString());
        }
        if (!nilable && obj == Nil.NIL) {
            throw new ExecError(cr, "Invalid value for " + this.getTypeString(), "'" + vcName + " = " + Nil.NIL.toString() + "' is not valid, maybe try '" + vcName + "? = " + Nil.NIL.toString() + "'");
        }
        if (obj != null) {
            if (!isKnown) {
                if (typesafe && !objType.equals("Nil")) {
                    safedType = objType;
                }
            } else {
                if (safedType != null && convert) {
                    obj = this.iConvert(safedType, objType, obj);
                    objType = Lib_Type.getName(obj);
                }
                if (typesafe && safedType != null && obj != Nil.NIL) {
                    obj = Lib_Type.typeCheck(cr, obj, objType, safedType, String.valueOf(this.getTypeString()) + ": " + vcName);
                }
            }
        }
        if (obj instanceof JMo_Java && Lib_Java.isSimpleTypeName(safedType)) {
            safedType = ((JMo_Java)obj).getFullTypeName();
        }
        this.map.put(vcName, new Group2<String, I_Object>(safedType, obj));
    }

    public String toString() {
        String sll = this.map == null ? "null" : "" + this.map.size();
        String sp = this.parent == null ? "" : " --> Parent: " + this.parent;
        return "VarEnv (Size:" + sll + ")" + sp;
    }

    private void init() {
        if (this.map == null) {
            this.map = new HashMap();
        }
    }

    private I_Object iConvert(String defType, String objType, I_Object obj) {
        block28: {
            boolean objIsInt;
            block26: {
                boolean objIsDec = obj instanceof I_Decimal;
                if (!objIsDec) break block26;
                switch (defType) {
                    case "Byte": {
                        return new JMo_Byte(((Number)((A_DecNumber)obj).getValue()).byteValue());
                    }
                    case "Short": {
                        return new JMo_Short(((Number)((A_DecNumber)obj).getValue()).shortValue());
                    }
                    case "Int": {
                        return new Int(((Number)((A_DecNumber)obj).getValue()).intValue());
                    }
                    case "Long": {
                        return new JMo_Long(((Number)((A_DecNumber)obj).getValue()).longValue());
                    }
                }
            }
            if (!(objIsInt = obj instanceof I_Integer)) break block28;
            switch (defType) {
                case "Float": {
                    return new JMo_Float(((Number)((A_IntNumber)obj).getValue()).floatValue());
                }
                case "Dec": {
                    return new Dec(((Number)((A_IntNumber)obj).getValue()).doubleValue());
                }
            }
        }
        return obj;
    }

    private final String getTypeString() {
        return this.isConst ? "constant" : "variable";
    }

    public void setCopy(String name, Group2<String, I_Object> g) {
        this.init();
        this.map.put(name, g);
    }
}

