/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.parser.func;

import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.parser.Parser_Call;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.parser.func.I_ParseFunc;
import org.jaymo_lang.util.Lib_Error;

public class ParseFunc_StringSetGet
implements I_ParseFunc {
    @Override
    public boolean hits(char c0, String s) {
        return c0 == ':' && s.length() >= 2 && s.charAt(1) != ':';
    }

    @Override
    public Group2<Call, String> parse(Parser_Script parser, Block current, I_Object obj, String s, boolean isArgument) {
        String rem = s.substring(1);
        String str = this.iString(rem);
        rem = rem.substring(str.length()).trim();
        if (str.length() == 0) {
            throw new CodeError("Invalid key for set/get", "Got empty string for get/set with ':', valid are: A-Z,a-z,0-9,_", parser.getDebugInfo());
        }
        boolean isSet = rem.length() >= 2 && rem.charAt(0) == '=' && rem.charAt(1) != '=';
        return isSet ? this.iSet(parser, current, obj, str, rem) : this.iGet(parser, current, obj, str, rem);
    }

    private Group2<Call, String> iGet(Parser_Script parser, Block current, I_Object obj, String str, String rest) {
        Call[] aPos = new Call[]{new Call(current, new Str(str), parser.getDebugInfo())};
        Lib_Error.ifArgs(aPos.length, 1, null, "get", parser.getDebugInfo());
        Call c = new Call(current, obj, "get", aPos, parser.getDebugInfo());
        return new Group2<Call, String>(c, rest);
    }

    private Group2<Call, String> iSet(Parser_Script parser, Block current, I_Object obj, String str, String rest) {
        String arg = rest.substring(rest.indexOf(61) + 1).trim();
        Call[] aPar = Parser_Call.parseArguments(parser, current, arg);
        Err.ifNot(1, aPar.length);
        Call cPar = aPar[0];
        Call[] aPos = new Call[]{new Call(current, new Str(str), parser.getDebugInfo())};
        Lib_Error.ifArgs(aPos.length, 1, null, "set", parser.getDebugInfo());
        int len = aPos.length;
        Call[] ca = new Call[len + 1];
        System.arraycopy(aPos, 0, ca, 1, len);
        ca[0] = cPar;
        Call c = new Call(current, obj, "set", ca, parser.getDebugInfo());
        return new Group2<Call, Object>(c, null);
    }

    private String iString(String s) {
        int p = 0;
        while (p <= s.length() - 1) {
            char c = s.charAt(p);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_')) {
                return s.substring(0, p);
            }
            ++p;
        }
        return s;
    }
}

