/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.parser.fdef;

import de.mn77.base.data.constant.CONDITION;
import java.util.ArrayList;
import org.jaymo_lang.error.ParseError;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.Function;
import org.jaymo_lang.parser.Parser_Call;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.util.Lib_Comply;

public class Lib_FDef {
    public static void setReturnCall(String sReturnValue, Parser_Script parser, Function f) {
        if (sReturnValue.length() > 0) {
            sReturnValue = sReturnValue.substring(1).trim();
            Call[] ca = Parser_Call.parseArguments(parser, f.getBlock(), sReturnValue);
            if (ca.length != 1) {
                throw new ParseError("Invalid function definition", "Invalid result for one-line-function", parser.getDebugInfo());
            }
            Call resultc = new Call(f.getBlock(), f, "return", ca, parser.getDebugInfo());
            f.getBlock().add(resultc);
            f.setOneLine();
        }
    }

    public static String[] toNames(Parser_Script parser, String s) {
        ArrayList<String> al = new ArrayList<String>();
        int start = 0;
        int end = 0;
        Boolean isPrivate = null;
        String name = null;
        while ((end = s.indexOf(124, start)) > -1) {
            name = s.substring(start, end).strip();
            if (isPrivate == null) {
                isPrivate = name.length() > 0 && Lib_FDef.isPrivate(name);
            }
            Lib_FDef.checkName(parser, name, isPrivate);
            al.add(name);
            start = end + 1;
        }
        name = s.substring(start).strip();
        Lib_FDef.checkName(parser, name, isPrivate);
        al.add(name);
        return al.toArray(new String[al.size()]);
    }

    public static boolean isPrivate(String s) {
        return s.charAt(0) == '_';
    }

    private static void checkName(Parser_Script parser, String name, Boolean isPrivate) {
        if (!Lib_Comply.checkFunctionName(name, isPrivate == null ? CONDITION.MAYBE : (isPrivate != false ? CONDITION.ALWAYS : CONDITION.NEVER))) {
            throw new ParseError("Invalid function name", "Illegal function name: " + name, parser.getDebugInfo());
        }
    }
}

