/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.parser;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.file.Lib_TextFile;
import de.mn77.base.version.I_VersionData;
import de.mn77.base.version.Lib_Version;
import java.io.File;
import org.jaymo_lang.JAYMO;
import org.jaymo_lang.model.App;
import org.jaymo_lang.parser.Parser_Script;

public class Parser_App {
    private boolean terminalModeRaw = false;
    private boolean debug = false;

    public Parser_App() {
        this(true);
    }

    public Parser_App(boolean versionUpdate) {
        if (versionUpdate) {
            this.versionUpdate(versionUpdate);
        }
    }

    public I_VersionData getVersion() {
        return JAYMO.VERSION;
    }

    public void setTerminalRawMode(boolean inRawMode) {
        this.terminalModeRaw = inRawMode;
    }

    public void setDebug() {
        this.debug = true;
    }

    public String getVersionString(boolean withBuild, boolean withDate) {
        String format = "%1.%2.%3%D" + (withBuild ? " (%b)" : "") + (withDate ? " - %dd.mm.yyyy" : "");
        return JAYMO.VERSION.toFormat(format);
    }

    public App parseFile(File datei) throws Err_FileSys {
        App app = new App(this.terminalModeRaw, this.debug);
        this.parseFile(app, datei);
        return app;
    }

    public void parseFile(App app, File datei) throws Err_FileSys {
        String source = Lib_TextFile.read(datei, true);
        this.iParseText(app, datei.getName(), source);
    }

    public App parseText(String source) {
        App app = new App(this.terminalModeRaw, this.debug);
        this.iParseText(app, "", source);
        return app;
    }

    public void parseText(App app, String source) throws Err_FileSys {
        this.iParseText(app, "", source);
    }

    private void iParseText(App app, String filename, String source) {
        Parser_Script ps = new Parser_Script(app, filename, source);
        ps.parse();
    }

    private void versionUpdate(boolean update) {
        try {
            Lib_Version.init(JAYMO.VERSION, false, update);
        }
        catch (Err_FileSys e) {
            Err.show(e);
        }
    }
}

