/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.model;

import de.mn77.base.error.Err;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Output;

public class VarArgsCallBuffer {
    private final Call[] calls;
    private I_Object[] obj = null;
    private boolean init = false;

    public VarArgsCallBuffer(Call[] ca) {
        Err.ifNull(new Object[]{ca});
        this.calls = ca;
    }

    public I_Object[] init(CallRuntime cr, I_Object streamIt) {
        if (this.init) {
            Err.todo("Already init!", this.obj);
        }
        I_Object[] result = new I_Object[this.calls.length];
        int i = 0;
        while (i < this.calls.length) {
            result[i] = Lib_Convert.getValue(cr, cr.execInit(this.calls[i], streamIt));
            ++i;
        }
        this.init = true;
        this.obj = result;
        return result;
    }

    public I_Object[] get() {
        if (!this.init) {
            Err.invalid("VarArgCallBuffer not initialized!", this.calls);
        }
        return this.obj;
    }

    public String toString() {
        return this.obj != null ? Lib_Output.toString(this.obj, true) : Lib_Output.toString(this.calls, false);
    }
}

