/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.bricklink;

import de.mn77.base.data.Lib_Math;
import java.util.HashMap;
import java.util.Map;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.lib.bricklink.Lib_Bricklink;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_Chars;
import org.jaymo_lang.object.atom.A_DecNumber;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public class ItemCreateData {
    private String item_no = null;
    private String item_type = null;
    private String color_id = null;
    private String quantity = null;
    private String unit_price = null;
    private String new_or_used = null;
    private String completeness = null;
    private String description = "";
    private String remarks = "";
    private String bulk = "1";
    private String is_retain = null;
    private String is_stock_room = null;
    private String stock_room_id = null;
    private String my_cost = null;
    private String sale_rate = null;
    private String tier_quantity1 = null;
    private String tier_price1 = null;
    private String tier_quantity2 = null;
    private String tier_price2 = null;
    private String tier_quantity3 = null;
    private String tier_price3 = null;

    public void fill(CallRuntime cr, HashMap<I_Object, I_Object> data) {
        for (Map.Entry<I_Object, I_Object> e : data.entrySet()) {
            String key;
            switch (key = Lib_Convert.getStringValue(cr, e.getKey()).toLowerCase()) {
                case "item.no": {
                    this.item_no = cr.argType(e.getValue(), Str.class).toString();
                    break;
                }
                case "item.type": {
                    this.item_type = cr.argType(e.getValue(), Str.class).toString();
                    this.item_type = Lib_Bricklink.checkItemType(cr, this.item_type);
                    break;
                }
                case "color_id": {
                    this.color_id = cr.argType(e.getValue(), A_IntNumber.class).toString();
                    break;
                }
                case "quantity": {
                    this.quantity = cr.argType(e.getValue(), A_IntNumber.class).toString();
                    break;
                }
                case "unit_price": {
                    this.unit_price = cr.argType(e.getValue(), A_DecNumber.class).toString();
                    break;
                }
                case "new_or_used": {
                    I_Object nuObject = cr.argTypeExt(e.getValue(), Bool.class, A_Chars.class);
                    boolean isNew = true;
                    isNew = nuObject instanceof Bool ? Lib_Convert.getBoolValue(cr, nuObject) : Lib_Convert.getStringValue(cr, nuObject).toUpperCase().equals("N");
                    this.new_or_used = isNew ? "N" : "U";
                    break;
                }
                case "completeness": {
                    this.completeness = cr.argType(e.getValue(), Str.class).toString();
                    this.completeness = Lib_Bricklink.checkSetCompleteness(cr, this.completeness);
                    break;
                }
                case "description": {
                    this.description = cr.argType(e.getValue(), Str.class).toString();
                    break;
                }
                case "remarks": {
                    this.remarks = cr.argType(e.getValue(), Str.class).toString();
                    break;
                }
                case "bulk": {
                    this.bulk = cr.argType(e.getValue(), A_IntNumber.class).toString();
                    break;
                }
                case "is_retain": {
                    this.is_retain = cr.argType(e.getValue(), Bool.class).toString();
                    break;
                }
                case "is_stock_room": {
                    this.is_stock_room = cr.argType(e.getValue(), Bool.class).toString();
                    break;
                }
                case "stock_room_id": {
                    this.stock_room_id = cr.argType(e.getValue(), Str.class).toString();
                    this.stock_room_id = Lib_Bricklink.checkStockRoomID(cr, this.stock_room_id);
                    break;
                }
                case "my_cost": {
                    this.my_cost = cr.argType(e.getValue(), A_DecNumber.class).toString();
                    break;
                }
                case "sale_rate": {
                    int sale = Lib_Convert.getIntValue(cr, cr.argType(e.getValue(), A_IntNumber.class));
                    this.sale_rate = Lib_Math.limit(0, 100, sale).toString();
                    break;
                }
                case "tier_quantity1": {
                    this.tier_quantity1 = cr.argType(e.getValue(), A_IntNumber.class).toString();
                    break;
                }
                case "tier_price1": {
                    this.tier_price1 = cr.argType(e.getValue(), A_DecNumber.class).toString();
                    break;
                }
                case "tier_quantity2": {
                    this.tier_quantity2 = cr.argType(e.getValue(), A_IntNumber.class).toString();
                    break;
                }
                case "tier_price2": {
                    this.tier_price2 = cr.argType(e.getValue(), A_DecNumber.class).toString();
                    break;
                }
                case "tier_quantity3": {
                    this.tier_quantity3 = cr.argType(e.getValue(), A_IntNumber.class).toString();
                    break;
                }
                case "tier_price3": {
                    this.tier_price3 = cr.argType(e.getValue(), A_DecNumber.class).toString();
                    break;
                }
                default: {
                    throw new ExecError(cr, "Invalid key", "Key is not known for inventory item: " + key);
                }
            }
        }
    }

    public void check(CallRuntime cr) {
        String missing = null;
        if (this.item_no == null) {
            missing = "item.no";
        }
        if (this.item_type == null) {
            missing = "item.type";
        }
        if (this.color_id == null) {
            missing = "color_id";
        }
        if (this.quantity == null) {
            missing = "quantity";
        }
        if (this.unit_price == null) {
            missing = "unit_price";
        }
        if (this.new_or_used == null) {
            missing = "new_or_used";
        }
        if (this.description == null) {
            missing = "description";
        }
        if (this.remarks == null) {
            missing = "remarks";
        }
        if (this.bulk == null) {
            missing = "bulk";
        }
        if (this.is_retain == null) {
            missing = "retain";
        }
        if (this.is_stock_room == null) {
            missing = "stock_room";
        }
        if (this.sale_rate == null) {
            missing = "sale_rate";
        }
        if (this.item_type != null && this.item_type.toLowerCase().equals("set") && this.completeness == null) {
            missing = "completeness";
        }
        if (this.tier_quantity1 != null || this.tier_price1 != null || this.tier_quantity2 != null || this.tier_price2 != null || this.tier_quantity3 != null || this.tier_price3 != null) {
            if (this.tier_quantity1 == null) {
                missing = "tier_quantity1";
            }
            if (this.tier_price1 == null) {
                missing = "tier_price1";
            }
            if (this.tier_quantity2 == null) {
                missing = "tier_quantity2";
            }
            if (this.tier_price2 == null) {
                missing = "tier_price2";
            }
            if (this.tier_quantity3 == null) {
                missing = "tier_quantity3";
            }
            if (this.tier_price3 == null) {
                missing = "tier_price3";
            }
        }
        if (missing != null) {
            throw new ExecError(cr, "Missing value to create inventory", "Missing: " + missing);
        }
    }

    public Map<String, String> getMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("item.no", this.item_no);
        map.put("item.type", this.item_type);
        map.put("color_id", this.color_id);
        map.put("quantity", this.quantity);
        map.put("unit_price", this.unit_price);
        map.put("new_or_used", this.new_or_used);
        if (this.completeness != null && this.item_type.toUpperCase().equals("SET")) {
            map.put("completeness", this.completeness);
        }
        map.put("description", this.description);
        map.put("remarks", this.remarks);
        map.put("bulk", this.bulk);
        map.put("is_retain", this.is_retain);
        map.put("is_stock_room", this.is_stock_room);
        if (this.stock_room_id != null && this.is_stock_room.equals("true")) {
            map.put("stock_room_id", this.stock_room_id);
        }
        map.put("my_cost", this.my_cost);
        map.put("sale_rate", this.sale_rate);
        map.put("tier_quantity1", this.tier_quantity1);
        map.put("tier_price1", this.tier_price1);
        map.put("tier_quantity2", this.tier_quantity2);
        map.put("tier_price2", this.tier_price2);
        map.put("tier_quantity3", this.tier_quantity3);
        map.put("tier_price3", this.tier_price3);
        return map;
    }
}

