/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.edit.refactor;

import de.mn77.base.data.convert.ConvString;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.group.Group3;
import de.mn77.base.data.group.Section;
import de.mn77.base.data.struct.table.type.TypeTable2;
import de.mn77.base.data.struct.table.type.TypeTable3;
import de.mn77.base.error.Err;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.StyledDocument;
import org.jaymo_lang.edit.editor.styler.styles.SECTION_TYPE;
import org.jaymo_lang.edit.refactor.REFACTOR;
import org.jaymo_lang.edit.refactor.RefactorStyle;

public class RefactorDocument
implements StyledDocument {
    private final String text;
    private final TypeTable3<Integer, Integer, SECTION_TYPE> table = new TypeTable3<Integer, Integer, SECTION_TYPE>(Integer.class, Integer.class, SECTION_TYPE.class);

    public RefactorDocument(String text) {
        this.text = text;
    }

    @Override
    public int getLength() {
        return this.text.length();
    }

    @Override
    public String getText(int offset, int length) throws BadLocationException {
        if (offset != 0 || length != this.text.length()) {
            Err.todo(offset, length, this.text.length());
        }
        return this.text;
    }

    @Override
    public void setCharacterAttributes(int offset, int length, AttributeSet s, boolean replace) {
        this.table.add(offset, length, ((RefactorStyle)s).getType());
    }

    public void show() {
        this.table.describe();
    }

    public Group3<Integer, Integer, SECTION_TYPE> getAt(int caretPosition) {
        if (caretPosition >= this.text.length()) {
            --caretPosition;
        } else {
            boolean isPart;
            char c = this.text.charAt(caretPosition);
            boolean bl = isPart = c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_';
            if (!isPart) {
                --caretPosition;
            }
        }
        for (Group3 group3 : this.table) {
            int start = (Integer)group3.o1;
            int end = (Integer)group3.o1 + (Integer)group3.o2;
            if (caretPosition < start || caretPosition >= end) continue;
            return group3;
        }
        return new Group3<Integer, Integer, SECTION_TYPE>(caretPosition, 1, SECTION_TYPE.LINEBREAK);
    }

    public String renameType(String oldName, String newName) {
        StringBuilder sb = new StringBuilder();
        for (Group3 group3 : this.table) {
            String part = this.text.substring((Integer)group3.o1, (Integer)group3.o1 + (Integer)group3.o2);
            if (group3.o3 == SECTION_TYPE.TYPE && part.equals(oldName)) {
                part = newName;
            }
            if (group3.o3 == SECTION_TYPE.DEFINITION) {
                Group2<String, String> def = this.iSplitDefinition(part);
                if (((String)def.o2).equals(oldName)) {
                    part = String.valueOf((String)def.o1) + newName;
                }
            }
            sb.append(part);
        }
        return sb.toString();
    }

    public String renameFunction(String oldName, String newName) {
        StringBuilder sb = new StringBuilder();
        for (Group3 group3 : this.table) {
            String part = this.text.substring((Integer)group3.o1, (Integer)group3.o1 + (Integer)group3.o2);
            if (group3.o3 == SECTION_TYPE.FUNCTION) {
                part = this.iRenameFunction(part, oldName, newName);
            }
            if (group3.o3 == SECTION_TYPE.DEFINITION) {
                Group2<String, String> def = this.iSplitDefinition(part);
                if (((String)def.o2).equals(oldName)) {
                    part = String.valueOf((String)def.o1) + newName;
                }
            }
            sb.append(part);
        }
        return sb.toString();
    }

    public String renameVar(String oldName, String newName) {
        StringBuilder sb = new StringBuilder();
        for (Group3 group3 : this.table) {
            String part = this.text.substring((Integer)group3.o1, (Integer)group3.o1 + (Integer)group3.o2);
            if (group3.o3 == SECTION_TYPE.VAR && part.equals(oldName)) {
                part = newName;
            }
            sb.append(part);
        }
        return sb.toString();
    }

    public String renameConst(String oldName, String newName) {
        StringBuilder sb = new StringBuilder();
        for (Group3 group3 : this.table) {
            String part = this.text.substring((Integer)group3.o1, (Integer)group3.o1 + (Integer)group3.o2);
            if (group3.o3 == SECTION_TYPE.CONST && part.equals(oldName)) {
                part = newName;
            }
            sb.append(part);
        }
        return sb.toString();
    }

    private Group2<String, String> iSplitDefinition(String def) {
        int gap = 0;
        char[] cArray = def.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (": \t".indexOf(c) <= -1) break;
            ++gap;
            ++n2;
        }
        return new Group2<String, String>(def.substring(0, gap), def.substring(gap));
    }

    private String iRenameFunction(String part, String oldName, String newName) {
        TypeTable2<String, Boolean> tab = ConvString.splitToTable(part, ".", ":");
        StringBuilder sb = new StringBuilder();
        for (Group2 group2 : tab) {
            if (((Boolean)group2.o2).booleanValue()) {
                sb.append((String)group2.o1);
                continue;
            }
            sb.append(((String)group2.o1).equals(oldName) ? newName : (String)group2.o1);
        }
        return sb.toString();
    }

    @Override
    public void addDocumentListener(DocumentListener listener) {
        Err.todo(new Object[0]);
    }

    @Override
    public void removeDocumentListener(DocumentListener listener) {
        Err.todo(new Object[0]);
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener listener) {
        Err.todo(new Object[0]);
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener listener) {
        Err.todo(new Object[0]);
    }

    @Override
    public Object getProperty(Object key) {
        Err.todo(new Object[0]);
        return null;
    }

    @Override
    public void putProperty(Object key, Object value) {
        Err.todo(new Object[0]);
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        Err.todo(new Object[0]);
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        Err.todo(new Object[0]);
    }

    @Override
    public void getText(int offset, int length, Segment txt) throws BadLocationException {
        Err.todo(new Object[0]);
    }

    @Override
    public Position getStartPosition() {
        Err.todo(new Object[0]);
        return null;
    }

    @Override
    public Position getEndPosition() {
        Err.todo(new Object[0]);
        return null;
    }

    @Override
    public Position createPosition(int offs) throws BadLocationException {
        Err.todo(new Object[0]);
        return null;
    }

    @Override
    public Element[] getRootElements() {
        Err.todo(new Object[0]);
        return null;
    }

    @Override
    public Element getDefaultRootElement() {
        Err.todo(new Object[0]);
        return null;
    }

    @Override
    public void render(Runnable r) {
        Err.todo(new Object[0]);
    }

    @Override
    public Style addStyle(String nm, Style parent) {
        Err.todo(new Object[0]);
        return null;
    }

    @Override
    public void removeStyle(String nm) {
        Err.todo(new Object[0]);
    }

    @Override
    public Style getStyle(String nm) {
        Err.todo(new Object[0]);
        return null;
    }

    @Override
    public void setParagraphAttributes(int offset, int length, AttributeSet s, boolean replace) {
        Err.todo(new Object[0]);
    }

    @Override
    public void setLogicalStyle(int pos, Style s) {
        Err.todo(new Object[0]);
    }

    @Override
    public Style getLogicalStyle(int p) {
        Err.todo(new Object[0]);
        return null;
    }

    @Override
    public Element getParagraphElement(int pos) {
        Err.todo(new Object[0]);
        return null;
    }

    @Override
    public Element getCharacterElement(int pos) {
        Err.todo(new Object[0]);
        return null;
    }

    @Override
    public Color getForeground(AttributeSet attr) {
        Err.todo(new Object[0]);
        return null;
    }

    @Override
    public Color getBackground(AttributeSet attr) {
        Err.todo(new Object[0]);
        return null;
    }

    @Override
    public Font getFont(AttributeSet attr) {
        Err.todo(new Object[0]);
        return null;
    }

    public ArrayList<Section> getOccurences(REFACTOR type, String word) {
        String part;
        ArrayList<Section> list = new ArrayList<Section>();
        int wordLen = word.length();
        if (type == REFACTOR.VARIABLE) {
            for (Group3 group3 : this.table) {
                if (group3.o3 != SECTION_TYPE.VAR || !(part = this.text.substring((Integer)group3.o1, (Integer)group3.o1 + (Integer)group3.o2)).equals(word)) continue;
                list.add(new Section((Integer)group3.o1, (Integer)group3.o2));
            }
        }
        if (type == REFACTOR.CONSTANT) {
            for (Group3 group3 : this.table) {
                if (group3.o3 != SECTION_TYPE.CONST || !(part = this.text.substring((Integer)group3.o1, (Integer)group3.o1 + (Integer)group3.o2)).equals(word)) continue;
                list.add(new Section((Integer)group3.o1, (Integer)group3.o2));
            }
        }
        if (type == REFACTOR.FUNCTION) {
            for (Group3 group3 : this.table) {
                if (group3.o3 != SECTION_TYPE.FUNCTION && group3.o3 != SECTION_TYPE.DEFINITION || !(part = this.text.substring((Integer)group3.o1, (Integer)group3.o1 + (Integer)group3.o2)).matches(".*\\b" + word + "\\b.*")) continue;
                int offset = 0;
                while (offset > -1) {
                    if ((offset = part.indexOf(word, offset)) <= -1) continue;
                    if (offset + wordLen == part.length() || part.substring(offset).matches(String.valueOf(word) + "\\b.*")) {
                        list.add(new Section((Integer)group3.o1 + offset, word.length()));
                    }
                    offset += wordLen;
                }
            }
        }
        return list;
    }
}

