/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.edit.editor.funcs;

import de.mn77.base.data.constant.DIRECTION_VERTICAL;
import de.mn77.base.data.group.Section;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import org.jaymo_lang.edit.editor.CodeEditor;
import org.jaymo_lang.edit.editor.funcs.Lib_EditFunctions;

public class Fn_MoveLines {
    public void init(final CodeEditor editor) {
        editor.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getModifiersEx() == 512 && e.getKeyCode() == 38) {
                    Fn_MoveLines.this.iMoveLines(editor, DIRECTION_VERTICAL.UP);
                }
                if (e.getModifiersEx() == 512 && e.getKeyCode() == 40) {
                    Fn_MoveLines.this.iMoveLines(editor, DIRECTION_VERTICAL.DOWN);
                }
            }
        });
    }

    private void iMoveLines(CodeEditor editor, DIRECTION_VERTICAL dir) {
        int cursorPos = editor.getCaretPosition();
        int markEnd = editor.getCaret().getMark();
        String text = editor.getText();
        Section selection = Lib_EditFunctions.getLines(text, cursorPos, markEnd);
        if (selection != null) {
            if (selection.start == 0 || selection.end >= text.length()) {
                return;
            }
            String textToMove = text.substring(selection.start, selection.end + 1);
            int cursorMoved = dir == DIRECTION_VERTICAL.UP ? selection.start - 1 : selection.end + 1;
            Section dodge = Lib_EditFunctions.getLines(text, cursorMoved, cursorMoved);
            String textToDodge = text.substring(dodge.start, dodge.end + 1);
            int dodgeLen = dodge.end - dodge.start + 1;
            if (dir == DIRECTION_VERTICAL.UP) {
                editor.select(selection.start, selection.end + 1);
                editor.replaceSelection("");
                editor.setCaretPosition(dodge.start);
                editor.replaceSelection(textToMove);
                editor.setCaretPosition(cursorPos - dodgeLen);
                if (markEnd > cursorPos) {
                    editor.select(cursorPos - dodgeLen, markEnd - dodgeLen);
                }
                if (markEnd < cursorPos) {
                    editor.select(markEnd - dodgeLen, cursorPos - dodgeLen);
                }
            } else {
                editor.select(dodge.start, dodge.end + 1);
                editor.replaceSelection("");
                editor.setCaretPosition(selection.start);
                editor.replaceSelection(textToDodge);
                editor.setCaretPosition(cursorPos + dodgeLen);
                if (markEnd > cursorPos) {
                    editor.select(cursorPos + dodgeLen, markEnd + dodgeLen);
                }
                if (markEnd < cursorPos) {
                    editor.select(markEnd + dodgeLen, cursorPos + dodgeLen);
                }
            }
            editor.getHistory().add();
        }
    }
}

