/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.sys;

import de.mn77.base.data.type.Lib_Class;
import de.mn77.base.error.Err;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.error.ParseError;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.ClassFinder;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Java;

public class JMo_Java
extends A_Object {
    private String classBuffer;
    private final ArgCallBuffer classNameCall;
    private final ArgCallBuffer constructorParList;
    private Object instance = null;
    private Class<?> instanceClass = null;

    public JMo_Java(Object instance) {
        this.instance = instance;
        this.instanceClass = instance.getClass();
        this.classBuffer = null;
        this.classNameCall = null;
        this.constructorParList = null;
    }

    public JMo_Java(Call[] args, DebugInfo debugInfo) {
        if (args.length < 1 || args.length > 2) {
            throw new ParseError("Invalid parameters for Java-constructor", "Want: (String class-name, List constructor_aruments)", debugInfo);
        }
        this.classBuffer = null;
        this.classNameCall = new ArgCallBuffer(0, args[0]);
        this.constructorParList = args.length == 1 ? null : new ArgCallBuffer(1, args[1]);
    }

    public JMo_Java(Class<?> cl, Call[] args, DebugInfo debugInfo) {
        this.instanceClass = cl;
        this.classBuffer = null;
        this.classNameCall = null;
        if (args == null || args.length == 0) {
            this.constructorParList = null;
        } else {
            Call cList = new Call(args[0].surrounding, new JMo_List(args), null, null, debugInfo);
            this.constructorParList = new ArgCallBuffer(0, cList);
        }
    }

    @Override
    public void init(CallRuntime cr) {
        cr.getStrict().checkSave(cr, "Java");
        if (this.instance == null) {
            if (this.classNameCall != null) {
                this.classNameCall.init(cr, this, Str.class);
            }
            if (this.constructorParList != null) {
                this.constructorParList.init(cr, this, JMo_List.class);
            }
            if (this.classBuffer == null && this.classNameCall != null) {
                I_Object oName = this.classNameCall.get();
                this.classBuffer = Lib_Convert.getStringValue(cr, oName);
            }
            if (this.classBuffer != null) {
                if (this.classBuffer.startsWith("JMo_")) {
                    throw new ExecError(cr, "It's not allowed to create JayMo-Objects via Java-Class!", this.classBuffer);
                }
                this.instanceClass = this.searchClass(cr);
            }
            try {
                this.instance = this.getInstance(cr, this.instanceClass);
            }
            catch (InstantiationException e) {
                this.instance = null;
            }
        }
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String m) {
        return Lib_Java.mExec(cr, this.instance, this.instanceClass, m, this);
    }

    public Object getJavaObject() {
        return this.instance == null ? this : this.instance;
    }

    public final String getJavaClassName() {
        return this.instanceClass.getSimpleName();
    }

    public Class<?> getJavaClass() {
        return this.instanceClass;
    }

    public Object getJavaInstance() {
        return this.instance;
    }

    public String getFullTypeName() {
        return Lib_Java.packConv_classToFull(this.instanceClass);
    }

    @Override
    public String toStringIdent(CallRuntime cr) {
        return this.toString(false);
    }

    @Override
    public String toString(boolean nested) {
        return Lib_Java.packConv_classToFull(this.instanceClass);
    }

    @Override
    public String toStringDescribe(CallRuntime cr) {
        StringBuilder sb = new StringBuilder();
        sb.append("Java(\"");
        sb.append(this.instanceClass.getName());
        sb.append('\"');
        sb.append(", ");
        if (this.constructorParList != null) {
            sb.append(this.constructorParList.toStringDescribe(cr));
        } else {
            sb.append("[]");
        }
        sb.append(")");
        return sb.toString();
    }

    private Object getInstance(CallRuntime cr, Class<?> cl) throws InstantiationException {
        if (this.constructorParList == null || ((ArrayList)((JMo_List)this.constructorParList.get()).getInternalCollection()).size() == 0) {
            if (cl.getConstructors().length == 0) {
                return null;
            }
            try {
                return cl.newInstance();
            }
            catch (IllegalAccessException e) {
                String message = e.getMessage().replace("Class " + JMo_Java.class.getName(), "You");
                throw new ExecError(cr, "Illegal access", message);
            }
            catch (SecurityException e) {
                throw new ExecError(cr, "Illegal access", e.getMessage());
            }
        }
        JMo_List parList = (JMo_List)this.constructorParList.get();
        if (!(parList instanceof JMo_List)) {
            throw new ExecError(cr, "Invalid parameters for construtor", "Want constructor-aruments within a list.");
        }
        Collection args = parList.getInternalCollection();
        Object[] javaPars = Lib_Java.jmoToJava(((ArrayList)args).toArray(new I_Object[((ArrayList)args).size()]));
        Class<?>[] javaParTypes = this.iJavaTypes(javaPars);
        Constructor<?> ca = null;
        try {
            ca = cl.getConstructor(javaParTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (ca == null) {
            ca = Lib_Class.getConstructor(cl, javaPars);
        }
        if (ca == null) {
            throw new ExecError(cr, "Invalid parameters for constructor", this.instanceClass.getName());
        }
        try {
            return ca.newInstance(javaPars);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new ExecError(cr, "Can't create object", e.getMessage());
        }
    }

    private Class<?>[] iJavaTypes(Object[] javaPars) {
        Class[] javaParTypes = new Class[javaPars.length];
        int i = 0;
        while (i < javaPars.length) {
            javaParTypes[i] = Lib_Java.toJavaType(javaPars[i]);
            ++i;
        }
        return javaParTypes;
    }

    private Class<?> searchClass(CallRuntime cr) {
        Err.ifNull(this.classBuffer);
        Class<?> result = null;
        int dotIdx = this.classBuffer.indexOf(46);
        if (dotIdx >= 0) {
            try {
                result = Class.forName(this.classBuffer);
            }
            catch (ClassNotFoundException e) {
                throw new ExecError(cr, "Java-Class not found!", this.classBuffer);
            }
        } else {
            result = ClassFinder.getInstance().searchJavaClass(this.classBuffer);
        }
        if (result == null) {
            throw new ExecError(cr, "Java-Class not found!", this.classBuffer);
        }
        if (Lib_Class.isChildOf(result, I_Object.class)) {
            throw new ExecError(cr, "It's not allowed to create JayMo-Objects via Java-Class!", this.classBuffer);
        }
        return result;
    }
}

