/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.immute.datetime;

import de.mn77.base.data.convert.ConvSequence;
import de.mn77.base.data.type.datetime.I_Date;
import de.mn77.base.data.type.datetime.I_Time;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.data.type.datetime.MTime;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.datetime.A_DateTimeBase;
import org.jaymo_lang.object.immute.datetime.JMo_Date;
import org.jaymo_lang.object.immute.datetime.JMo_DateTime;
import org.jaymo_lang.object.immute.datetime.Lib_DateTime_Format;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Type;

public class JMo_Time
extends A_DateTimeBase {
    private I_Time time = null;
    private final ArgCallBuffer[] init;

    public JMo_Time(I_Time time) {
        this.init = null;
        this.time = time;
    }

    public JMo_Time() {
        this.init = null;
    }

    public JMo_Time(Call str) {
        this.init = new ArgCallBuffer[]{new ArgCallBuffer(0, str)};
    }

    public JMo_Time(Call h, Call m) {
        this.init = new ArgCallBuffer[]{new ArgCallBuffer(0, h), new ArgCallBuffer(1, m)};
    }

    public JMo_Time(Call h, Call m, Call s) {
        this.init = new ArgCallBuffer[]{new ArgCallBuffer(0, h), new ArgCallBuffer(1, m), new ArgCallBuffer(3, s)};
    }

    @Override
    public void init(CallRuntime cr) {
        block10: {
            if (this.time != null) {
                return;
            }
            String errPars = "";
            try {
                if (this.init == null) {
                    this.time = new MTime();
                    break block10;
                }
                if (this.init.length == 1) {
                    String s;
                    I_Object o = this.init[0].initExt(cr, this, A_IntNumber.class, Str.class);
                    if (o instanceof A_IntNumber) {
                        int ih = Lib_Convert.getIntValue(cr, o);
                        errPars = "" + ih;
                        this.time = new MTime(ih, 0, 0);
                        break block10;
                    }
                    errPars = s = Lib_Convert.getStringValue(cr, o);
                    try {
                        this.time = new MTime(s);
                        break block10;
                    }
                    catch (Err_Runtime err) {
                        throw new ExecError(cr, "Can't create Time-Object", String.valueOf(err.getMessage()) + " Got: Time(" + s + ")");
                    }
                }
                if (this.init.length == 2) {
                    int ih = Lib_Convert.getIntValue(cr, this.init[0].init(cr, this, A_IntNumber.class));
                    int im = Lib_Convert.getIntValue(cr, this.init[1].init(cr, this, A_IntNumber.class));
                    errPars = String.valueOf(ih) + "," + im;
                    this.time = new MTime(ih, im, 0);
                } else {
                    int ih = Lib_Convert.getIntValue(cr, this.init[0].init(cr, this, A_IntNumber.class));
                    int im = Lib_Convert.getIntValue(cr, this.init[1].init(cr, this, A_IntNumber.class));
                    int is = Lib_Convert.getIntValue(cr, this.init[2].init(cr, this, A_IntNumber.class));
                    errPars = String.valueOf(ih) + "," + im + "," + is;
                    this.time = new MTime(ih, im, is);
                }
            }
            catch (Err_Runtime err) {
                throw new ExecError(cr, "Invalid time: " + ConvSequence.toText(", ", err.getDetails()), "Time(" + errPars + ")");
            }
        }
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "getHour": 
            case "getHours": {
                return A_Object.stdResult(this.mGetHours(cr));
            }
            case "getMin": 
            case "getMinutes": {
                return A_Object.stdResult(this.mGetMinutes(cr));
            }
            case "getSeconds": 
            case "getSec": {
                return A_Object.stdResult(this.mGetSeconds(cr));
            }
            case "addSec": 
            case "addSeconds": {
                return A_Object.stdResult(this.mAdd(cr, true));
            }
            case "addMin": 
            case "addMinutes": {
                return A_Object.stdResult(this.mAddSubMinutes(cr, true));
            }
            case "addHours": {
                return A_Object.stdResult(this.mAddSubHours(cr, true));
            }
            case "subSec": 
            case "subSeconds": {
                return A_Object.stdResult(this.mSubtract(cr, true));
            }
            case "subMin": 
            case "subMinutes": {
                return A_Object.stdResult(this.mAddSubMinutes(cr, false));
            }
            case "subHours": {
                return A_Object.stdResult(this.mAddSubHours(cr, false));
            }
            case "setHours": 
            case "setHour": {
                return A_Object.stdResult(this.mSetHour(cr));
            }
            case "setMinutes": 
            case "setMinute": {
                return A_Object.stdResult(this.mSetMinute(cr));
            }
            case "setSecond": 
            case "setSeconds": {
                return A_Object.stdResult(this.mSetSecond(cr));
            }
            case "combine": {
                return A_Object.stdResult(this.mCombine(cr));
            }
            case "diffHours": {
                return A_Object.stdResult(this.mDiffHours(cr));
            }
            case "diffMinutes": {
                return A_Object.stdResult(this.mDiffMinutes(cr));
            }
            case "diffSeconds": 
            case "diff": {
                return A_Object.stdResult(this.mDiffSeconds(cr));
            }
        }
        return null;
    }

    @Override
    public String toStringIdent(CallRuntime cr) {
        if (this.time == null) {
            return "Time";
        }
        return "Time(\"" + this.toString() + "\")";
    }

    @Override
    public String toString(boolean nested) {
        if (this.time == null) {
            return Lib_Type.getName(this);
        }
        return this.time.toString();
    }

    @Override
    public String toStringDescribe(CallRuntime cr) {
        return String.valueOf(Lib_Type.getName(this)) + "(\"" + this.time.toString() + "\")";
    }

    @Override
    public boolean equalsLazy(Object other) {
        if (other instanceof Str) {
            return ((Str)other).getValue().equals(this.time.toString());
        }
        return this.equals(other);
    }

    @Override
    protected boolean[] mCompare2(CallRuntime cr) {
        JMo_Time other = (JMo_Time)cr.args(this, JMo_Time.class)[0];
        boolean isEqual = this.time.isEqual(other.getInternalValue());
        boolean isGreater = this.time.isGreater(other.getInternalValue());
        return new boolean[]{isEqual, isGreater};
    }

    @Override
    public boolean equals(Object arg) {
        return arg instanceof JMo_Time ? this.time.isEqual(((JMo_Time)arg).getInternalTime()) : false;
    }

    private Int mDiffSeconds(CallRuntime cr) {
        JMo_Time arg = (JMo_Time)cr.args(this, JMo_Time.class)[0];
        int diff = this.time.diffSeconds(arg.getInternalValue());
        return new Int(diff);
    }

    private Int mDiffMinutes(CallRuntime cr) {
        JMo_Time arg = (JMo_Time)cr.args(this, JMo_Time.class)[0];
        int diff = this.time.diffMinutes(arg.getInternalValue());
        return new Int(diff);
    }

    private Int mDiffHours(CallRuntime cr) {
        JMo_Time arg = (JMo_Time)cr.args(this, JMo_Time.class)[0];
        int diff = this.time.diffHours(arg.getInternalValue());
        return new Int(diff);
    }

    private Int mGetSeconds(CallRuntime cr) {
        cr.args();
        return new Int(this.time.getSeconds());
    }

    private Int mGetMinutes(CallRuntime cr) {
        cr.args();
        return new Int(this.time.getMinutes());
    }

    private Int mGetHours(CallRuntime cr) {
        cr.args();
        return new Int(this.time.getHours());
    }

    private I_Object mAdd(CallRuntime cr, boolean seconds) {
        I_Object arg;
        I_Object i_Object = arg = seconds ? cr.args(this, A_IntNumber.class)[0] : cr.argsExt(this, new Class[][]{{A_IntNumber.class, JMo_Time.class}})[0];
        if (arg instanceof A_IntNumber) {
            int pari = Lib_Convert.getIntValue(cr, arg);
            I_Time date2 = this.time.getAddSeconds(pari);
            return new JMo_Time(date2);
        }
        if (arg instanceof JMo_Time) {
            I_Time part = ((JMo_Time)arg).getInternalTime();
            I_Time temp = this.time;
            temp = temp.getAddHours(part.getHours());
            temp = temp.getAddMinutes(part.getMinutes());
            temp = temp.getAddSeconds(part.getSeconds());
            return new JMo_Time(temp);
        }
        throw Err.impossible(Lib_Type.getName(arg));
    }

    private JMo_Time mSubtract(CallRuntime cr, boolean seconds) {
        I_Object arg;
        I_Object i_Object = arg = seconds ? cr.args(this, A_IntNumber.class)[0] : cr.argsExt(this, new Class[][]{{A_IntNumber.class, JMo_Time.class}})[0];
        if (arg instanceof A_IntNumber) {
            int pari = Lib_Convert.getIntValue(cr, arg);
            I_Time date2 = this.time.getAddSeconds(-pari);
            return new JMo_Time(date2);
        }
        if (arg instanceof JMo_Time) {
            I_Time part = ((JMo_Time)arg).getInternalTime();
            I_Time temp = this.time;
            temp = temp.getAddHours(-part.getHours());
            temp = temp.getAddMinutes(-part.getMinutes());
            temp = temp.getAddSeconds(-part.getSeconds());
            return new JMo_Time(temp);
        }
        throw Err.impossible(Lib_Type.getName(arg));
    }

    private JMo_Time mAddSubMinutes(CallRuntime cr, boolean add) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        if (!add) {
            pari = -pari;
        }
        I_Time date2 = this.time.getAddMinutes(pari);
        return new JMo_Time(date2);
    }

    private JMo_Time mAddSubHours(CallRuntime cr, boolean add) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        if (!add) {
            pari = -pari;
        }
        I_Time date2 = this.time.getAddHours(pari);
        return new JMo_Time(date2);
    }

    private I_Object mCombine(CallRuntime cr) {
        I_Object arg = cr.args(this, JMo_Date.class)[0];
        MDateTime dt = new MDateTime(((JMo_Date)arg).getInternalDate(), this.time);
        return new JMo_DateTime(dt);
    }

    private JMo_Time mSetHour(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_Time time2 = this.time.getSetHour(pari);
        return new JMo_Time(time2);
    }

    private JMo_Time mSetMinute(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_Time time2 = this.time.getSetMinute(pari);
        return new JMo_Time(time2);
    }

    private JMo_Time mSetSecond(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_Time time2 = this.time.getSetSecond(pari);
        return new JMo_Time(time2);
    }

    @Override
    protected JMo_Time incdec2(boolean inc, int amount) {
        if (inc) {
            I_Time date2 = this.time.getAddSeconds(amount);
            return new JMo_Time(date2);
        }
        I_Time date2 = this.time.getAddSeconds(-amount);
        return new JMo_Time(date2);
    }

    @Override
    protected JMo_Time mLimit(CallRuntime cr) {
        I_Object[] args = cr.args(this, JMo_Time.class, JMo_Time.class);
        I_Time min = ((JMo_Time)args[0]).time;
        I_Time max = ((JMo_Time)args[1]).time;
        if (this.time.isGreater(max)) {
            return (JMo_Time)args[1];
        }
        if (min.isGreater(this.time)) {
            return (JMo_Time)args[0];
        }
        return this;
    }

    @Override
    protected I_Object mStyle(CallRuntime cr, A_DateTimeBase.COUNTRY country) {
        cr.args();
        switch (country) {
            case DE: {
                return Lib_DateTime_Format.format(cr, "hh:mm:ss", this.getInternalDate(), this.getInternalTime());
            }
            case EN: {
                return Lib_DateTime_Format.format(cr, "hh:mm:ss", this.getInternalDate(), this.getInternalTime());
            }
            case US: {
                return Lib_DateTime_Format.format(cr, "i:mm:ss p", this.getInternalDate(), this.getInternalTime());
            }
        }
        throw Err.impossible(new Object[]{country});
    }

    private I_Time getInternalValue() {
        return this.time;
    }

    @Override
    protected I_Date getInternalDate() {
        return null;
    }

    @Override
    protected I_Time getInternalTime() {
        return this.time;
    }

    @Override
    protected I_Object mAddSub(CallRuntime cr, boolean add) {
        return add ? this.mAdd(cr, false) : this.mSubtract(cr, false);
    }
}

