/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.atom;

import java.util.ArrayList;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.model.COMPARE;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_Atomic;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.I_AtomicValue;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.ATOMIC;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_MagicVar;

public class Nil
extends A_Atomic
implements I_Atomic {
    public static final Nil NIL = new Nil();

    private Nil() {
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "*": 
            case "mul": {
                return A_Object.stdResult(this.mMultiply(cr));
            }
        }
        Lib_MagicVar.checkForbiddenFuncs(cr, method);
        return null;
    }

    public static JMo_List arithmetic(CallRuntime cr, A_Number.NOP1 op, int intValue) {
        if (op == A_Number.NOP1.MUL) {
            ArrayList<I_Object> al = new ArrayList<I_Object>(intValue);
            int i = 0;
            while (i < intValue) {
                al.add(NIL);
                ++i;
            }
            return new JMo_List(al);
        }
        throw new CodeError(cr, "Invalid function for Nil", op.toString());
    }

    private I_Object mMultiply(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int amount = Lib_Convert.getIntValue(cr, arg);
        return Nil.arithmetic(cr, A_Number.NOP1.MUL, amount);
    }

    @Override
    public Object getValue() {
        return NIL;
    }

    @Override
    public Integer compareTo3(I_AtomicValue o) {
        if (o instanceof Nil) {
            return 0;
        }
        return null;
    }

    @Override
    public String toStringIdent() {
        return this.toString();
    }

    @Override
    public String toString(boolean nested) {
        return "nil";
    }

    @Override
    public I_AtomicValue convertTo(CallRuntime cr, ATOMIC to) {
        return NIL;
    }

    @Override
    protected Bool mComparsion(CallRuntime cr, COMPARE m) {
        throw new ExecError(cr, "Nil Exception", "Object is nil");
    }

    @Override
    protected Int getLength(CallRuntime cr) {
        return new Int(3);
    }
}

