/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.lib.swing.A_Swing_Object;
import org.jaymo_lang.lib.swing.I_Swing_Object;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public abstract class A_Swing_Frame
extends A_Swing_Object {
    private final ArgCallBuffer par_dx;
    private final ArgCallBuffer par_dy;
    private final ArgCallBuffer par_title;
    protected final JFrame frame;
    private STATE state = STATE.PREPARED;

    public A_Swing_Frame() {
        this(null, null, null);
    }

    public A_Swing_Frame(Call title) {
        this(null, null, title);
    }

    public A_Swing_Frame(Call dx, Call dy) {
        this(dx, dy, null);
    }

    public A_Swing_Frame(Call dx, Call dy, Call title) {
        this.par_dx = dx == null ? null : new ArgCallBuffer(0, dx);
        this.par_dy = dy == null ? null : new ArgCallBuffer(1, dy);
        this.par_title = title == null ? null : new ArgCallBuffer(2, title);
        this.frame = new JFrame();
        GridLayout l = new GridLayout(0, 1);
        this.frame.setLayout(l);
        ImageIcon img = new ImageIcon(this.getClass().getClassLoader().getResource("jar/logo/jaymo_icon_256.png"));
        this.frame.setIconImage(img.getImage());
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.par_dx != null && this.par_dy != null) {
            int width = Lib_Convert.getIntValue(cr, this.par_dx.init(cr, this, A_IntNumber.class));
            int height = Lib_Convert.getIntValue(cr, this.par_dy.init(cr, this, A_IntNumber.class));
            this.frame.setSize(width, height);
        }
        if (this.par_title != null) {
            String title = Lib_Convert.getStringValue(cr, this.par_title.init(cr, this, Str.class));
            this.frame.setTitle(title);
        }
    }

    @Override
    protected final I_Object callMethod2(CallRuntime cr, String method) {
        if (this.state == STATE.CLOSED) {
            throw new ExecError(cr, "Illegal Frame-Access", "This Frame is already closed");
        }
        switch (method) {
            case "maximize": {
                cr.args();
                this.frame.setExtendedState(this.frame.getExtendedState() | 6);
                return this;
            }
            case "add": {
                I_Object[] addObjs;
                I_Object[] i_ObjectArray = addObjs = cr.argsVar(this, 1, 0);
                int n = addObjs.length;
                int n2 = 0;
                while (n2 < n) {
                    I_Object o = i_ObjectArray[n2];
                    I_Swing_Object so = (I_Swing_Object)cr.argType(o, I_Swing_Object.class);
                    this.frame.getContentPane().add(so.getSwing());
                    ++n2;
                }
                return this;
            }
            case "setSize": {
                this.size(cr, SIZE.CURRENT);
                return this;
            }
            case "setSizeMin": {
                this.size(cr, SIZE.MIN);
                return this;
            }
            case "setTitle": {
                String title = Lib_Convert.getStringValue(cr, cr.args(this, Str.class)[0]);
                this.frame.setTitle(title);
                return this;
            }
            case "pack": {
                cr.args();
                this.frame.pack();
                return this;
            }
        }
        return this.callMethod3(cr, method);
    }

    protected abstract I_Object callMethod3(CallRuntime var1, String var2);

    protected void closeFrame(CallRuntime cr, boolean stateCheck) {
        if (stateCheck) {
            switch (this.state) {
                case PREPARED: {
                    throw new ExecError(cr, "Illegal Frame-Access", "This frame is not running.");
                }
                case CLOSED: {
                    throw new ExecError(cr, "Illegal Frame-Access", "This frame is closed.");
                }
            }
        }
        this.frame.dispose();
        this.state = STATE.CLOSED;
    }

    protected void setRunState(CallRuntime cr, boolean stateCheck) {
        if (stateCheck) {
            switch (this.state) {
                case RUNNING: {
                    throw new ExecError(cr, "Illegal Frame-Access", "This frame is already running.");
                }
                case CLOSED: {
                    throw new ExecError(cr, "Illegal Frame-Access", "This frame is closed.");
                }
            }
        }
        this.state = STATE.RUNNING;
    }

    protected boolean isRunning() {
        return this.state == STATE.RUNNING;
    }

    private A_Swing_Frame size(CallRuntime cr, SIZE s) {
        I_Object[] args = cr.args(this, Int.class, Int.class);
        int dx = Lib_Convert.getIntValue(cr, args[0]);
        int dy = Lib_Convert.getIntValue(cr, args[1]);
        if (dx <= 0 || dy <= 0) {
            throw new ExecError(cr, "Value out of bounds", "Minimum of 1 useful, got " + dx + "/" + dy);
        }
        switch (s) {
            case CURRENT: {
                this.frame.setSize(dx, dy);
                break;
            }
            case MIN: {
                this.frame.setMinimumSize(new Dimension(dx, dy));
                break;
            }
            case MAX: {
                this.frame.setMaximumSize(new Dimension(dx, dy));
            }
        }
        return this;
    }

    @Override
    public Component getSwing() {
        return this.frame;
    }

    private static enum SIZE {
        CURRENT,
        MIN,
        MAX;

    }

    protected static enum STATE {
        PREPARED,
        RUNNING,
        CLOSED;

    }
}

