/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.graphic;

import de.mn77.base.data.Lib_Math;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.file.I_Directory;
import de.mn77.base.sys.file.I_File;
import de.mn77.lib.graphic.IMAGE_FORMAT;
import de.mn77.lib.graphic.I_Image;
import de.mn77.lib.graphic.Lib_Graphic;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class MImage
implements I_Image {
    public static final int MAX_PIXEL = 4096;
    protected BufferedImage image = null;
    private int farbbits = 0;

    public MImage(BufferedImage img, int bits) {
        this.image = img;
        this.farbbits = bits;
    }

    public MImage(Object bild, int dx, int dy) throws Err_FileSys {
        Err.ifNull(bild);
        Err.ifOutOfBounds(0.0, 3000.0, dx);
        Err.ifOutOfBounds(0.0, 3000.0, dy);
        if (bild instanceof I_Image) {
            bild = ((I_Image)bild).getImage();
        }
        if (bild instanceof BufferedImage) {
            this.iNEU((BufferedImage)bild, ((BufferedImage)bild).getColorModel().getPixelSize(), dx, dy);
        } else if (bild instanceof ImageIcon) {
            this.iNEU(((ImageIcon)bild).getImage(), 24, dx, dy);
        } else if (bild instanceof Image) {
            MediaTracker tracker = new MediaTracker(null);
            tracker.addImage((Image)bild, 0);
            try {
                tracker.waitForAll();
            }
            catch (InterruptedException ie) {
                Err.wrap(ie, bild);
            }
            this.iNEU((Image)bild, 24, dx, dy);
        } else if (bild instanceof I_File) {
            BufferedImage temp = null;
            try {
                temp = ImageIO.read(((I_File)bild).read());
            }
            catch (IOException e) {
                Err.wrap(e, (I_File)bild);
            }
            this.iNEU(temp, temp.getColorModel().getPixelSize(), dx, dy);
        } else if (bild instanceof InputStream) {
            BufferedImage temp = null;
            try {
                temp = ImageIO.read((InputStream)bild);
            }
            catch (IOException e) {
                Err.wrap(e, bild);
            }
            this.iNEU(temp, temp.getColorModel().getPixelSize(), dx, dy);
        } else if (bild instanceof File) {
            BufferedImage temp = null;
            try {
                temp = ImageIO.read((File)bild);
            }
            catch (IOException e) {
                Err.wrap(e, bild);
            }
            if (temp == null) {
                Err.direct("Image read error", new Object[0]);
            }
            this.iNEU(temp, temp.getColorModel().getPixelSize(), dx, dy);
        } else if (bild instanceof String) {
            BufferedImage temp = null;
            try {
                temp = ImageIO.read(new File("" + bild));
            }
            catch (IOException e) {
                Err.wrap(e, bild);
            }
            if (temp == null) {
                Err.direct("Konnte Bild nicht lesen", new Object[0]);
            }
            this.iNEU(temp, temp.getColorModel().getPixelSize(), dx, dy);
        } else if (bild instanceof byte[]) {
            BufferedImage temp = null;
            try {
                ByteArrayInputStream is = new ByteArrayInputStream((byte[])bild);
                temp = ImageIO.read(is);
            }
            catch (IOException e) {
                Err.wrap(e, bild);
            }
            if (temp == null) {
                Err.direct("Konnte Bild nicht lesen", new Object[0]);
            }
            this.iNEU(temp, temp.getColorModel().getPixelSize(), dx, dy);
        } else {
            throw Err.invalid("Unbekannter Objekt-Typ", bild, bild.getClass().getSimpleName());
        }
    }

    public MImage(Object bild) throws Err_FileSys {
        this(bild, 0, 0);
    }

    public MImage(int dx, int dy, int rot, int gruen, int blau) {
        this(dx, dy, rot, gruen, blau, 255);
    }

    public MImage(int dx, int dy, int rot, int gruen, int blau, int alpha) {
        Err.ifOutOfBounds(0.0, 4096.0, dx);
        Err.ifOutOfBounds(0.0, 4096.0, dy);
        Err.ifOutOfBounds(0.0, 255.0, rot);
        Err.ifOutOfBounds(0.0, 255.0, gruen);
        Err.ifOutOfBounds(0.0, 255.0, blau);
        Err.ifOutOfBounds(0.0, 255.0, alpha);
        this.image = new BufferedImage(dx, dy, 2);
        Graphics2D g2d = this.image.createGraphics();
        g2d.setColor(new Color(rot, gruen, blau, alpha));
        g2d.fillRect(0, 0, dx, dy);
        g2d.dispose();
        this.farbbits = 24;
    }

    @Override
    public I_File save(I_Directory v, String name, IMAGE_FORMAT format, boolean addSuffix) throws Err_FileSys {
        Err.ifNull(new Object[]{v, name, format});
        I_File erg = null;
        try {
            BufferedImage speichern = this.image;
            if (format != IMAGE_FORMAT.GIF && format != IMAGE_FORMAT.PNG) {
                speichern = this.iARGBzuRGB(this.image);
            }
            erg = v.fileFlex(name, format.defaultSuffix);
            ImageIO.write((RenderedImage)speichern, this.iSchreibformat(format), erg.write());
            speichern.flush();
        }
        catch (IOException e) {
            Err.wrap(e, v, name);
        }
        return erg;
    }

    @Override
    public void save(String datei, IMAGE_FORMAT format, boolean addSuffix) throws Err_FileSys {
        Err.ifNull(new Object[]{datei, format});
        try {
            BufferedImage speichern = this.image;
            if (format != IMAGE_FORMAT.GIF && format != IMAGE_FORMAT.PNG) {
                speichern = this.iARGBzuRGB(this.image);
            }
            if (addSuffix) {
                datei = String.valueOf(datei) + "." + format.defaultSuffix;
            }
            ImageIO.write((RenderedImage)speichern, this.iSchreibformat(format), new File(datei));
            speichern.flush();
        }
        catch (IOException e) {
            Err.wrap(e, datei);
        }
    }

    @Override
    public void saveJPEG(String datei, boolean addSuffix) throws Err_FileSys {
        this.iSaveJPEG(datei, null, addSuffix);
    }

    @Override
    public void saveJPEG(String datei, int qualitaet, boolean addSuffix) throws Err_FileSys {
        this.iSaveJPEG(datei, qualitaet, addSuffix);
    }

    public void iSaveJPEG(String datei, Integer qualitaet, boolean addSuffix) throws Err_FileSys {
        Err.ifNull(datei);
        if (addSuffix) {
            datei = String.valueOf(datei) + "." + IMAGE_FORMAT.JPEG.defaultSuffix;
        }
        try {
            BufferedImage imageToSave = this.iARGBzuRGB(this.image);
            File file = new File(datei);
            FileOutputStream out = new FileOutputStream(file);
            ImageWriter imageWriter = ImageIO.getImageWritersBySuffix("jpeg").next();
            ImageOutputStream ios = ImageIO.createImageOutputStream(out);
            imageWriter.setOutput(ios);
            IIOMetadata imageMetaData = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(imageToSave), null);
            JPEGImageWriteParam jpegParams = (JPEGImageWriteParam)imageWriter.getDefaultWriteParam();
            if (qualitaet != null) {
                Err.ifOutOfBounds(1.0, 100.0, qualitaet.intValue());
                jpegParams.setCompressionMode(2);
                jpegParams.setCompressionQuality((float)qualitaet.intValue() / 100.0f);
            } else {
                jpegParams.setCompressionMode(1);
            }
            imageWriter.write(imageMetaData, new IIOImage(imageToSave, null, null), jpegParams);
            ios.close();
            imageWriter.dispose();
        }
        catch (IOException e) {
            Err.wrap(e, datei);
        }
    }

    @Override
    public I_Image copy() {
        BufferedImage b = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 2);
        b.setData(this.image.getData());
        try {
            return new MImage(b);
        }
        catch (Err_FileSys e) {
            throw Err.impossible(new Object[0]);
        }
    }

    @Override
    public void dispose() {
        this.image.flush();
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public int getColorBitsOriginal() {
        return this.farbbits;
    }

    @Override
    public BufferedImage getImage() {
        return this.image;
    }

    @Override
    public Icon getIcon() {
        return new ImageIcon(this.image);
    }

    private I_Image iNEU(Image bild, int farbbits, int dx, int dy) {
        this.farbbits = farbbits;
        this.image = dx > 0 && dy > 0 ? this.iZu24Bit(bild, (Integer)Lib_Math.min((Comparable[])new Integer[]{bild.getWidth(null), dx}), (Integer)Lib_Math.min((Comparable[])new Integer[]{bild.getHeight(null), dy})) : this.iZu24Bit(bild);
        return this;
    }

    private String iSchreibformat(IMAGE_FORMAT typ) {
        if (typ == IMAGE_FORMAT.JPEG) {
            return "jpg";
        }
        if (typ == IMAGE_FORMAT.PNG) {
            return "png";
        }
        if (typ == IMAGE_FORMAT.BMP) {
            return "bmp";
        }
        throw Err.invalid("Nicht unterst\u00fctzter Bildtyp: " + (Object)((Object)typ));
    }

    private BufferedImage iZu24Bit(Image bild) {
        BufferedImage neu = new BufferedImage(bild.getWidth(null), bild.getHeight(null), 2);
        Graphics2D g2d2 = neu.createGraphics();
        g2d2.drawImage(bild, 0, 0, null);
        g2d2.dispose();
        return neu;
    }

    private BufferedImage iZu24Bit(Image bild, int dx, int dy) {
        Point p = Lib_Graphic.calcResize(bild.getWidth(null), bild.getHeight(null), dx, dy);
        BufferedImage neu = new BufferedImage(p.x, p.y, 2);
        Graphics2D g2d = neu.createGraphics();
        g2d.drawImage(bild, 0, 0, p.x, p.y, null);
        g2d.dispose();
        return neu;
    }

    private BufferedImage iARGBzuRGB(BufferedImage bild) {
        BufferedImage erg = new BufferedImage(bild.getWidth(), bild.getHeight(), 1);
        Graphics2D g2d2 = erg.createGraphics();
        g2d2.drawImage((Image)bild, 0, 0, null);
        g2d2.dispose();
        return erg;
    }

    @Override
    public byte[] getBytesPNG() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)this.image, "png", baos);
        }
        catch (IOException e) {
            Err.wrap(e, new Object[0]);
        }
        return baos.toByteArray();
    }
}

