/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.convert;

import de.mn77.base.data.filter.FilterString;
import de.mn77.base.data.search.SearchText;
import de.mn77.base.data.struct.table.type.TypeTable2;
import de.mn77.base.data.type.datetime.I_Date;
import de.mn77.base.data.type.datetime.I_DateTime;
import de.mn77.base.data.type.datetime.MDate;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.error.Err;
import java.util.ArrayList;

public class ConvString {
    public static String[] csvLineToString(String line, char delimiter_field, char delimiter_col) {
        ArrayList<String> result = new ArrayList<String>();
        boolean open = false;
        boolean double_tf = false;
        String field = "";
        int p = 0;
        while (p < line.length()) {
            boolean last;
            char c = line.charAt(p);
            boolean bl = last = p == line.length() - 1;
            if (c == delimiter_field) {
                if (double_tf) {
                    double_tf = false;
                    field = String.valueOf(field) + c;
                } else if (open) {
                    if (last || line.charAt(p + 1) != delimiter_field) {
                        open = false;
                    } else {
                        double_tf = true;
                    }
                } else {
                    open = true;
                }
            } else if (!open && c == delimiter_col) {
                result.add(field);
                field = "";
                if (last) {
                    result.add("");
                }
            } else {
                field = String.valueOf(field) + c;
            }
            ++p;
        }
        if (field.length() > 0) {
            result.add(field);
        }
        return result.toArray(new String[result.size()]);
    }

    public static Integer toInteger(String s) {
        if (s == null) {
            return null;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Boolean toBoolean(String s) {
        if (s == null) {
            return null;
        }
        try {
            return Boolean.parseBoolean(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static TypeTable2<String, Boolean> splitToTable(String s, String ... delimiter) {
        TypeTable2<String, Boolean> result = new TypeTable2<String, Boolean>(String.class, Boolean.class);
        TypeTable2<Integer, String> tab = SearchText.positionsMulti(s, delimiter);
        int tz = 1;
        while (tz <= tab.size()) {
            int start = (Integer)tab.getCol1().get(tz);
            String delim = (String)tab.getCol2().get(tz);
            if (tz == 1 && start > 1) {
                result.add(FilterString.cut(1, start - 1, s), false);
            }
            int bis = tz < tab.size() ? (Integer)tab.getCol1().get(tz + 1) - 1 : s.length();
            int fromText = start + delim.length();
            result.add(delim, true);
            if (fromText <= bis) {
                result.add(FilterString.cut(fromText, bis - fromText + 1, s), false);
            }
            ++tz;
        }
        if (tab.size() == 0 && s.length() > 0) {
            result.add(s, false);
        }
        return result;
    }

    public static <T> T toObject(String s, Class<T> c) {
        if (s == null) {
            return null;
        }
        Err.ifNull(c);
        if (c == String.class) {
            return (T)s;
        }
        if (c == Integer.class) {
            return (T)Integer.valueOf(Integer.parseInt(s));
        }
        if (c == I_Date.class) {
            return (T)new MDate(s);
        }
        if (c == Boolean.class) {
            return (T)Boolean.valueOf(Boolean.parseBoolean(s));
        }
        if (c == I_DateTime.class) {
            return (T)new MDateTime(s);
        }
        throw Err.todo("Unknown Class to convert", s, c);
    }

    public static ArrayList<String> toList(String delimiter, String s) {
        Err.ifEmpty(delimiter);
        Err.ifNull(s);
        ArrayList<String> result = new ArrayList<String>();
        if (s.length() == 0) {
            return result;
        }
        int start = 1;
        if (s.indexOf(delimiter) == 0) {
            result.add("");
        } else {
            start -= delimiter.length();
        }
        while (start <= s.length()) {
            int nt = s.indexOf(delimiter, (start += delimiter.length()) - 1) + 1;
            if (nt < 1) {
                nt = s.length() + 1;
            }
            if (start > s.length()) {
                result.add("");
            } else {
                result.add(FilterString.cut(start, nt - start, s));
            }
            start += nt - start;
        }
        return result;
    }

    public static String[] toStringArray(String delimiter, String s) {
        ArrayList<String> c = ConvString.toList(delimiter, s);
        return c.toArray(new String[c.size()]);
    }

    public static ArrayList<String> toLines(String s) {
        return ConvString.toList("\n", s);
    }

    public static ArrayList<String> toList(char delimiter, String s) {
        Err.ifNull(s);
        ArrayList<String> result = new ArrayList<String>();
        if (s.length() == 0) {
            return result;
        }
        int start = 0;
        int pos = 0;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == delimiter) {
                result.add(s.substring(start, pos));
                start = pos + 1;
            }
            ++pos;
            ++n2;
        }
        if (start < pos) {
            result.add(s.substring(start, pos));
        }
        if (start == pos && s.charAt(pos - 1) == delimiter) {
            result.add("");
        }
        return result;
    }

    public static ArrayList<String> toSearchWords(String s) {
        String word;
        Err.ifNull(s);
        s = s.trim();
        ArrayList<String> result = new ArrayList<String>();
        if (s.length() == 0) {
            return result;
        }
        int start = 0;
        int pos = 0;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == ' ') {
                String word2 = s.substring(start, pos).trim();
                if (word2.length() > 0) {
                    result.add(word2);
                }
                start = pos + 1;
            }
            ++pos;
            ++n2;
        }
        if (start < pos && (word = s.substring(start, pos).trim()).length() > 0) {
            result.add(word);
        }
        return result;
    }

    public static String[] toStringArray(char delimiter, String s) {
        ArrayList<String> c = ConvString.toList(delimiter, s);
        return c.toArray(new String[c.size()]);
    }
}

